;/**
; *******************************************************************************
; * @file    startup_TMPM311.s
; * @brief   CMSIS Cortex-M3 Core Device Startup File for the
; *          TOSHIBA 'TMPM311' Device Series
; * @version V2.0.2.3
; * @date    2016/07/11
; *------- <<< Use Configuration Wizard in Context Menu >>> ------------------
; * 
; * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
; * 
; * (C)Copyright TOSHIBA ELECTRONIC DEVICES & STORAGE CORPORATION 2017 All rights reserved
; *******************************************************************************
; */

; <h> Stack Configuration
;   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Stack_Size      EQU     0x00000200

                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   Stack_Size
__initial_sp


; <h> Heap Configuration
;   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Heap_Size       EQU     0x00000000

                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit


                PRESERVE8
                THUMB


; Vector Table Mapped to Address 0 at Reset

                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors

__Vectors       DCD     __initial_sp              ; Top of Stack
                DCD     Reset_Handler             ; Reset Handler
                DCD     NMI_Handler               ; NMI Handler
                DCD     HardFault_Handler         ; Hard Fault Handler
                DCD     MemManage_Handler         ; MPU Fault Handler
                DCD     BusFault_Handler          ; Bus Fault Handler
                DCD     UsageFault_Handler        ; Usage Fault Handler
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     SVC_Handler               ; SVCall Handler
                DCD     DebugMon_Handler          ; Debug Monitor Handler
                DCD     0                         ; Reserved
                DCD     PendSV_Handler            ; PendSV Handler
                DCD     SysTick_Handler           ; SysTick Handler

                ; External Interrupts
                DCD     INTDSADA_IRQHandler       ; 0:	DSAD conversion complete interrupt (unitA)
                DCD     INTDSADB_IRQHandler       ; 1:	DSAD conversion complete interrupt (unitB)
                DCD     INTDSADC_IRQHandler       ; 2:	DSAD conversion complete interrupt (unitC)
                DCD     INTDSADD_IRQHandler       ; 3:	DSAD conversion complete interrupt (unitD)
                DCD     INT0_IRQHandler           ; 4:	Interrupt pin 0
                DCD     INT1_IRQHandler           ; 5:	Interrupt pin 1
                DCD     INTSSP0_IRQHandler        ; 6:	SSP0 interrupt
                DCD     INTRX0_IRQHandler         ; 7:	Serial0 reception interrupt
                DCD     INTTX0_IRQHandler         ; 8:	Serial0 transmission interrupt
                DCD     INTTB0_IRQHandler         ; 9:	16-bit TMRB0 compare match detection interrupt
                DCD     INTTB1_IRQHandler         ; 10:	16-bit TMRB1 compare match detection interrupt
                DCD     INTTB2_IRQHandler         ; 11:	16-bit TMRB2 compare match detection interrupt
                DCD     INTTB3_IRQHandler         ; 12:	16-bit TMRB3 compare match detection interrupt
                DCD     INTCAP00_IRQHandler       ; 13:	16-bit TMRB0 input capture 0 detection interrupt
                DCD     INTCAP01_IRQHandler       ; 14:	16-bit TMRB0 input capture 1 detection interrupt
                DCD     INTCAP10_IRQHandler       ; 15:	16-bit TMRB1 input capture 0 detection interrupt
                DCD     INTCAP11_IRQHandler       ; 16:	16-bit TMRB1 input capture 1 detection interrupt
                DCD     INTT16A0_IRQHandler       ; 17:	16-bit TMR16A0 match detection
                DCD     INTDMAATC0_IRQHandler     ; 18:	DMAC 0 transmission completion interrupt (unitA)
                DCD     INTDMAATC1_IRQHandler     ; 19:	DMAC 1 transmission completion interrupt (unitA)
                DCD     INTDMAATC2_IRQHandler     ; 20:	DMAC 2 transmission completion interrupt (unitA)
                DCD     INTDMAATC3_IRQHandler     ; 21:	DMAC 3 transmission completion interrupt (unitA)
                DCD     INTDMAAERR_IRQHandler     ; 22:	DMAC transmissioni error interrupt (unitA)



                AREA    |.text|, CODE, READONLY


; Reset Handler

Reset_Handler   PROC
                EXPORT  Reset_Handler             [WEAK]
                IMPORT  SystemInit
                IMPORT  __main
                LDR     R0, =SystemInit
                BLX     R0
                LDR     R0, =__main
                BX      R0
                ENDP


; Dummy Exception Handlers (infinite loops which can be modified)

NMI_Handler     PROC
                EXPORT  NMI_Handler               [WEAK]
                B       .
                ENDP
HardFault_Handler\
                PROC
                EXPORT  HardFault_Handler         [WEAK]
                B       .
                ENDP
MemManage_Handler\
                PROC
                EXPORT  MemManage_Handler         [WEAK]
                B       .
                ENDP
BusFault_Handler\
                PROC
                EXPORT  BusFault_Handler          [WEAK]
                B       .
                ENDP
UsageFault_Handler\
                PROC
                EXPORT  UsageFault_Handler        [WEAK]
                B       .
                ENDP
SVC_Handler     PROC
                EXPORT  SVC_Handler               [WEAK]
                B       .
                ENDP
DebugMon_Handler\
                PROC
                EXPORT  DebugMon_Handler          [WEAK]
                B       .
                ENDP
PendSV_Handler  PROC
                EXPORT  PendSV_Handler            [WEAK]
                B       .
                ENDP
SysTick_Handler PROC
                EXPORT  SysTick_Handler           [WEAK]
                B       .
                ENDP

Default_Handler PROC

                EXPORT  INTDSADA_IRQHandler       [WEAK]
                EXPORT  INTDSADB_IRQHandler       [WEAK]
                EXPORT  INTDSADC_IRQHandler       [WEAK]
                EXPORT  INTDSADD_IRQHandler       [WEAK]
                EXPORT  INT0_IRQHandler           [WEAK]
                EXPORT  INT1_IRQHandler           [WEAK]
                EXPORT  INTSSP0_IRQHandler        [WEAK]
                EXPORT  INTRX0_IRQHandler         [WEAK]
                EXPORT  INTTX0_IRQHandler         [WEAK]
                EXPORT  INTTB0_IRQHandler         [WEAK]
                EXPORT  INTTB1_IRQHandler         [WEAK]
                EXPORT  INTTB2_IRQHandler         [WEAK]
                EXPORT  INTTB3_IRQHandler         [WEAK]
                EXPORT  INTCAP00_IRQHandler       [WEAK]
                EXPORT  INTCAP01_IRQHandler       [WEAK]
                EXPORT  INTCAP10_IRQHandler       [WEAK]
                EXPORT  INTCAP11_IRQHandler       [WEAK]
                EXPORT  INTT16A0_IRQHandler       [WEAK]
                EXPORT  INTDMAATC0_IRQHandler     [WEAK]
                EXPORT  INTDMAATC1_IRQHandler     [WEAK]
                EXPORT  INTDMAATC2_IRQHandler     [WEAK]
                EXPORT  INTDMAATC3_IRQHandler     [WEAK]
                EXPORT  INTDMAAERR_IRQHandler     [WEAK]

INTDSADA_IRQHandler
INTDSADB_IRQHandler
INTDSADC_IRQHandler
INTDSADD_IRQHandler
INT0_IRQHandler
INT1_IRQHandler
INTSSP0_IRQHandler
INTRX0_IRQHandler
INTTX0_IRQHandler
INTTB0_IRQHandler
INTTB1_IRQHandler
INTTB2_IRQHandler
INTTB3_IRQHandler
INTCAP00_IRQHandler
INTCAP01_IRQHandler
INTCAP10_IRQHandler
INTCAP11_IRQHandler
INTT16A0_IRQHandler
INTDMAATC0_IRQHandler
INTDMAATC1_IRQHandler
INTDMAATC2_IRQHandler
INTDMAATC3_IRQHandler
INTDMAAERR_IRQHandler

                B       .

                ENDP


                ALIGN


; User Initial Stack & Heap

                IF      :DEF:__MICROLIB

                EXPORT  __initial_sp
                EXPORT  __heap_base
                EXPORT  __heap_limit

                ELSE

                IMPORT  __use_two_region_memory
                EXPORT  __user_initial_stackheap
__user_initial_stackheap

                LDR     R0, =  Heap_Mem
                LDR     R1, =(Stack_Mem + Stack_Size)
                LDR     R2, = (Heap_Mem +  Heap_Size)
                LDR     R3, = Stack_Mem
                BX      LR

                ALIGN

                ENDIF


                END

