/**
 *******************************************************************************
 * @file    tmpm311_cg.h
 * @brief   This file provides all the functions prototypes for CG driver.
 * @version V2.0.2.2
 * @date    2014/10/14
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * (C)Copyright TOSHIBA ELECTRONIC DEVICES & STORAGE CORPORATION 2017 All rights reserved
 *******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __TMPM311_CG_H
#define __TMPM311_CG_H

#ifdef __cplusplus
extern "C" {
#endif                          /* __cplusplus */

/* Includes ------------------------------------------------------------------*/
#include "TMPM311.h"
#include "tx03_common.h"

/** @addtogroup TX03_Periph_Driver
  * @{
  */

/** @addtogroup CG
  * @{
  */

/** @addtogroup CG_Exported_types
  * @{
  */

    typedef enum {
        CG_DIVIDE_1 = 0U,
        CG_DIVIDE_2 = 1U,
        CG_DIVIDE_4 = 2U,
        CG_DIVIDE_8 = 3U,
        CG_DIVIDE_16 = 4U,
        CG_DIVIDE_32 = 5U,
        CG_DIVIDE_64 = 6U,
        CG_DIVIDE_128 = 7U,
        CG_DIVIDE_256 = 8U,
        CG_DIVIDE_512 = 9U,
        CG_DIVIDE_UNKNOWN = 10U,
        CG_DIVIDE_MAX = 11U
    } CG_DivideLevel;
#define IS_CG_GEAR_DIVIDE_LEVEL(param)  (((param) == CG_DIVIDE_1) || \
                                         ((param) == CG_DIVIDE_2) || \
                                         ((param) == CG_DIVIDE_4) || \
                                         ((param) == CG_DIVIDE_8) || \
                                         ((param) == CG_DIVIDE_16))

#define IS_CG_FC_DIDIDE_LEVEL(param)    (((param) == CG_DIVIDE_1) || \
                                         ((param) == CG_DIVIDE_2) || \
                                         ((param) == CG_DIVIDE_4) || \
                                         ((param) == CG_DIVIDE_8) || \
                                         ((param) == CG_DIVIDE_16)|| \
                                         ((param) == CG_DIVIDE_32))

#define IS_CG_DIVIDE_FC_LEVEL(param)    (((param) == CG_DIVIDE_1) || \
                                         ((param) == CG_DIVIDE_2) || \
                                         ((param) == CG_DIVIDE_4) || \
                                         ((param) == CG_DIVIDE_8) || \
                                         ((param) == CG_DIVIDE_16) || \
                                         ((param) == CG_DIVIDE_32) || \
                                         ((param) == CG_DIVIDE_64)|| \
                                         ((param) == CG_DIVIDE_128) || \
                                         ((param) == CG_DIVIDE_256) || \
                                         ((param) == CG_DIVIDE_512))

    typedef enum {
        CG_FC_SRC_FOSC = 0U,
        CG_FC_SRC_IHOSC = 1U
    } CG_FcSrc;
#define IS_CG_FC_SRC(param)    (((param) == CG_FC_SRC_FOSC) || \
                                ((param) == CG_FC_SRC_IHOSC))

    typedef enum {
        CG_PHIT0_SRC_FGEAR = 0U,
        CG_PHIT0_SRC_FC = 1U,
        CG_PHIT0_SRC_MAX = 2U
    } CG_PhiT0Src;
#define IS_CG_PHIT0_SRC(param)  (((param) == CG_PHIT0_SRC_FGEAR) || \
                                 ((param) == CG_PHIT0_SRC_FC))

    typedef enum {
        CG_STICK_SRC_IHOSC = 0U,
        CG_STICK_SRC_FOSC = 1U,
        CG_STICK_SRC_MAX = 2U
    } CG_SysTickSrc;
#define IS_CG_STICK_SRC(param)  (((param) == CG_STICK_SRC_IHOSC) || \
                                 ((param) == CG_STICK_SRC_FOSC))

    typedef enum {
        CG_INT_ACTIVE_STATE_L = 0x00U,
        CG_INT_ACTIVE_STATE_H = 0x01U,
        CG_INT_ACTIVE_STATE_FALLING = 0x02U,
        CG_INT_ACTIVE_STATE_RISING = 0x03U,
        CG_INT_ACTIVE_STATE_BOTH_EDGES = 0x04U,
        CG_INT_ACTIVE_STATE_INVALID = 0x05U
    } CG_INTActiveState;
#define IS_CG_INT_ACTIVE_STATE(param)          (((param) == CG_INT_ACTIVE_STATE_L) || \
                                                ((param) == CG_INT_ACTIVE_STATE_H) || \
                                                ((param) == CG_INT_ACTIVE_STATE_FALLING) || \
                                                ((param) == CG_INT_ACTIVE_STATE_RISING) || \
                                                ((param) == CG_INT_ACTIVE_STATE_BOTH_EDGES))

#define IS_CG_INT_ACTIVE_STATE_FALLING(param)      ((param) == CG_INT_ACTIVE_STATE_FALLING)

#define IS_CG_INT_ACTIVE_STATE_RISING(param)       ((param) == CG_INT_ACTIVE_STATE_RISING)


    typedef enum {
        CG_WARM_UP_SRC_OSC_INT_HIGH = 0U,
        CG_WARM_UP_SRC_OSC_EXT_HIGH = 1U
    } CG_WarmUpSrc;
#define IS_CG_WARM_UP_SRC(param)        (((param) == CG_WARM_UP_SRC_OSC_INT_HIGH) || \
                                         ((param) == CG_WARM_UP_SRC_OSC_EXT_HIGH))

#define IS_CG_WARM_UP_TIME_HIGH(param)     ((param) < 0x1000U)

    typedef enum {
        CG_FOSC_OSC_EXT = 0U,
        CG_FOSC_OSC_INT = 1U,
        CG_FOSC_CLKIN_EXT = 2U,
        CG_FOSC_UNKNOWN = 3U
    } CG_FoscSrc;
#define IS_CG_FOSC_SRC(param)           (((param) == CG_FOSC_OSC_EXT) || \
                                         ((param) == CG_FOSC_CLKIN_EXT))

#define IS_CG_FOSC_STATE(param)         (((param) == CG_FOSC_OSC_EXT) || \
                                         ((param) == CG_FOSC_OSC_INT) )

    typedef enum {
        CG_INT_SRC_0 = 0U,
        CG_INT_SRC_1 = 1U,
    } CG_INTSrc;

#define IS_CG_INT_SRC(param)    (((param) == CG_INT_SRC_0) || \
                                 ((param) == CG_INT_SRC_1))



    typedef union {
        uint32_t All;
        struct {
            uint32_t PinReset:1;
            uint32_t Reserved1:2;
            uint32_t WDTReset:1;
            uint32_t SYSRESETREQ:1;
            uint32_t Reserved2:27;
        } Bit;
    } CG_ResetFlag;

/** @} */
/* End of group CG_Exported_types */

/** @defgroup CG_Exported_FunctionPrototypes
  * @{
  */
    void CG_SetFgearLevel(CG_DivideLevel DivideFgearFromFc);
    CG_DivideLevel CG_GetFgearLevel(void);
    void CG_SetPhiT0Src(CG_PhiT0Src PhiT0Src);
    CG_PhiT0Src CG_GetPhiT0Src(void);
    void CG_SetSysTickSrc(CG_SysTickSrc SysTickSrc);
    CG_SysTickSrc CG_GetSysTickSrc(void);
    Result CG_SetPhiT0Level(CG_DivideLevel DividePhiT0FromFc);
    CG_DivideLevel CG_GetPhiT0Level(void);
    void CG_SetWarmUpTime(CG_WarmUpSrc Source, uint16_t Time);
    void CG_StartWarmUp(void);
    WorkState CG_GetWarmUpState(void);
    Result CG_SetFosc(CG_FoscSrc Source, FunctionalState NewState);
    void CG_SetFoscSrc(CG_FoscSrc Source);
    CG_FoscSrc CG_GetFoscSrc(void);
    FunctionalState CG_GetFoscState(CG_FoscSrc Source);
    Result CG_SetFcSrc(CG_FcSrc Source);
    CG_FcSrc CG_GetFcSrc(void);
    void CG_SetProtectCtrl(FunctionalState NewState);
    void CG_SetSTBYReleaseINTSrc(CG_INTSrc INTSource, CG_INTActiveState ActiveState);
    CG_INTActiveState CG_GetSTBYReleaseINTState(CG_INTSrc INTSource);
    void CG_ClearINTReq(CG_INTSrc INTSource);
    CG_ResetFlag CG_GetResetFlag(void);

/** @} */
/* End of group CG_Exported_FunctionPrototype */

/** @} */
/* End of group CG */

/** @} */
/* End of group TX03_Periph_Driver */

#ifdef __cplusplus
}
#endif                          /* __cplusplus */
#endif                          /* __TMPM311_CG_H */
