/**
 *******************************************************************************
 * @file    tmpm311_dsad.h
 * @brief   This file provides all the functions prototypes for DSADC driver.
 * @version V2.0.2.1
 * @date    2014/09/02
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * (C)Copyright TOSHIBA ELECTRONIC DEVICES & STORAGE CORPORATION 2017 All rights reserved
 *******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __TMPM311_DSDSADC_H
#define __TMPM311_DSDSADC_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "TMPM311.h"
#include "tx03_common.h"

/** @addtogroup TX03_Periph_Driver
  * @{
  */

/** @addtogroup DSADC
  * @{
  */

/** @defgroup DSADC_Exported_Types
  * @{
  */

#define IS_DSADC_PERIPH(param)       (((param) == TSB_DSADA)  || \
                                      ((param) == TSB_DSADB)  || \
                                      ((param) == TSB_DSADC)  || \
                                      ((param) == TSB_DSADD))

#define     DSADC_FC_DIVIDE_LEVEL_1         ((uint32_t)0x00000000)
#define     DSADC_FC_DIVIDE_LEVEL_2         ((uint32_t)0x00000001)
#define     DSADC_FC_DIVIDE_LEVEL_4         ((uint32_t)0x00000002)
#define     DSADC_FC_DIVIDE_LEVEL_8         ((uint32_t)0x00000003)
#define     IS_DSADC_CLOCK_SEL(param)       ((param) <= DSADC_FC_DIVIDE_LEVEL_8)

#define     DSADC_GAIN_1x                   ((uint32_t)0x00000000)
#define     DSADC_GAIN_2x                   ((uint32_t)0x00000001)
#define     DSADC_GAIN_4x                   ((uint32_t)0x00000002)
#define     DSADC_GAIN_8x                   ((uint32_t)0x00000003)
#define     DSADC_GAIN_16x                  ((uint32_t)0x00000004)
#define     IS_DSADC_GAIN(param)            ((param) <= DSADC_GAIN_16x)

#define     DSADC_A_SYNC_MODE               ((uint32_t)0x00000000)
#define     DSADC_SYNC_MODE                 ((uint32_t)0x00000001)
#define     DSADC_SINGLE_MODE               ((uint32_t)0x00000000)
#define     DSADC_REPEAT_MODE               ((uint32_t)0x00000001)
#define     IS_DSADC_1BIT_CHECK(param)      ((param) <= 1U)

#define     DSADC_HARDWARE_TRIGGER_EXT      ((uint32_t)0x00000000)
#define     DSADC_HARDWARE_TRIGGER_INT      ((uint32_t)0x00000001)
#define     IS_DSADC_HARDWARE_TRIGGER(param)   ((param) <= 1U)

#define     DSADC_ANALOG_INPUT_DAIN         ((uint32_t)0x00000000)
#define     DSADC_ANALOG_INPUT_INT          ((uint32_t)0x00000001)
#define     IS_DSADC_ANALOG_INPUT(DSADCx, AnalogInput)    ((((DSADCx) == TSB_DSADD) && ((AnalogInput) <= 1U)) ||\
                                                           (((DSADCx) != TSB_DSADD) && ((AnalogInput) < 1U)))

    typedef struct {
        uint32_t Clk;
        uint32_t BiasEn;
        uint32_t ModulatorEn;
        uint32_t HardwareFactor;
        FunctionalState HardwareEn;
        uint32_t SyncMode;
        uint32_t Repeatmode;
        uint32_t Amplifier;
        uint32_t AnalogInput;
        uint16_t Offset;
        uint32_t CorrectEn;
    } DSADC_InitTypeDef;

    typedef union {
        uint32_t All;
        struct {
            uint32_t F_ResultStore:1;
            uint32_t F_Overrun:1;
            uint32_t F_Convert:1;
            uint32_t F_ConvertEnd:1;
            uint32_t Reserved:4;
            uint32_t ConversionResult:24;
        } Bit;
    } DSAD_status;


/** @} */
/* End of group DSADC_Exported_Types */

/** @defgroup DSADC_Exported_FunctionPrototypes
  * @{
  */
    void DSADC_SetClk(TSB_DSAD_TypeDef * DSADCx, uint32_t Clk);
    void DSADC_SWReset(TSB_DSAD_TypeDef * DSADCx);
    void DSADC_Start(TSB_DSAD_TypeDef * DSADCx);
    void DSADC_ChangeMode(TSB_DSAD_TypeDef * DSADCx, uint32_t SyncMode, uint32_t ConvMode);
    void DSADC_SetHWStartup(TSB_DSAD_TypeDef * DSADCx, FunctionalState NewState);
    void DSADC_SetHWStartupFactor(TSB_DSAD_TypeDef * DSADCx, uint32_t StartupFactor);
    void DSADC_SetAmplifier(TSB_DSAD_TypeDef * DSADCx, uint32_t Amplifier);
    void DSADC_SetAnalogInput(TSB_DSAD_TypeDef * DSADCx, uint32_t AnalogInput);
    uint32_t DSADC_GetConvertResult(TSB_DSAD_TypeDef * DSADCx);
    void DSADC_Init(TSB_DSAD_TypeDef * DSADCx, DSADC_InitTypeDef * InitStruct);
    DSAD_status DSADC_GetStatus(TSB_DSAD_TypeDef * DSADCx);

/** @} */
/* End of group DSADC_Exported_FunctionPrototypes */

/** @} */
/* End of group DSADC */

/** @} */
/* End of group TX03_Periph_Driver */


#ifdef __cplusplus
}
#endif
#endif                          /* __TMPM311_DSDSADC_H */
