/**
 *******************************************************************************
 * @file    tmpm311_temp.h
 * @brief   This file provides all the functions prototypes for TEMP driver.
 * @version V2.0.2.1
 * @date    2014/09/04
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * (C)Copyright TOSHIBA ELECTRONIC DEVICES & STORAGE CORPORATION 2017 All rights reserved
 *******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __TMPM311_TEMP_H
#define __TMPM311_TEMP_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "TMPM311.h"
#include "tx03_common.h"


/** @addtogroup TX03_Periph_Driver
  * @{
  */

/** @addtogroup TEMP
  * @{
  */

/** @defgroup TEMP_Exported_Types
  * @{
  */

/** 
  * @brief  TEMP Init Structure definition 
  */

/** @} */
/* End of group TEMP_Exported_Types */

/** @defgroup TEMP_Exported_Constants
  * @{
  */

/** @} */
/* End of TEMP_Exported_Constants */

/** @addtogroup TEMP_Exported_types
  * @{
  */

/** @} */
/* End of TEMP_Exported_types */

/** @defgroup TEMP_Exported_FunctionPrototypes
  * @{
  */

    void TEMP_SetAMPState(FunctionalState NewState);
    FunctionalState TEMP_GetAMPState(void);
    void TEMP_SetBGRState(FunctionalState NewState);
    FunctionalState TEMP_GetBGRState(void);
    void TEMP_SetSensorState(FunctionalState NewState);
    FunctionalState TEMP_GetSensorState(void);

/** @} */
/* End of TEMP_Exported_FunctionPrototypes */

/** @} */
/* End of group TEMP */

/** @} */
/* End of group TX03_Periph_Driver */


#ifdef __cplusplus
}
#endif
#endif                          /* defined(__TMPM311_TEMP_H) */
