/**
 *******************************************************************************
 * @file    tmpm311_udmac.h
 * @brief   This file provides all the functions prototypes for uDMAC driver.
 * @version V2.0.2.1
 * @date    2014/09/03
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * (C)Copyright TOSHIBA ELECTRONIC DEVICES & STORAGE CORPORATION 2017 All rights reserved
 *******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __TMPM311_uDMAC_H
#define __TMPM311_uDMAC_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "TMPM311.h"
#include "TX03_common.h"

/** @addtogroup TX03_Periph_Driver
  * @{
  */

/** @addtogroup uDMAC
  * @{
  */

/** @defgroup uDMAC_Exported_Constants
  * @{
  */
#define DMAC_UNIT_A  TSB_DMAA   /* redefine the name in m311.h */
#define IS_DMAC_UNIT(param)              ((param) == DMAC_UNIT_A)


/** @} */
/* End of group uDMAC_Exported_Constants */


/** @defgroup uDMAC_Exported_Types
  * @{
  */

/*DMACA  channels*/
#define DMACA_SSP0_RX                     ((uint8_t)0x00)
#define DMACA_SSP0_TX                     ((uint8_t)0x01)
#define DMACA_UART0_RX                    ((uint8_t)0x02)
#define DMACA_UART0_TX                    ((uint8_t)0x03)
#define IS_DMACA_CHANNEL_ALL(param)       ((param) <= DMACA_UART0_TX)
#define IS_DMACA_CHANNEL_SINGLE(param)    ((param) <= DMACA_SSP0_TX)

#define IS_DMAC_CHANNEL_ALL(param1,param2) (((param1) == DMAC_UNIT_A) && ((param2) <= DMACA_UART0_TX))

    typedef enum {
        DMAC_PRIMARY = 0U,
        DMAC_ALTERNATE = 1U
    } DMAC_PrimaryAlt;
#define IS_DMAC_PRIMARYALT(param)         ((param) <= DMAC_ALTERNATE)
#define IS_DMAC_CTRL_BASE(param)          (((param) & (uint32_t)0x000003FF) == (uint32_t)0x00000000)

    typedef enum {
        DMAC_SINGLE = 0U,
        DMAC_BURST = 1U
    } DMAC_TransferType;
#define IS_DMAC_TRANSFERTYPE(param)       ((param) <= DMAC_BURST)

    typedef enum {
        DMAC_PRIOTIRY_NORMAL = 0U,
        DMAC_PRIOTIRY_HIGH = 1U
    } DMAC_Priority;
#define IS_DMAC_PRIORITY(param)           ((param) <= DMAC_PRIOTIRY_HIGH)


    typedef enum {
        DMAC_BYTE = 0U,         /* data size of transfer is 1 byte */
        DMAC_HALF_WORD = 1U,    /* data size of transfer is 2 bytes */
        DMAC_WORD = 2U          /* data size of transfer is 4 bytes */
    } DMAC_BitWidth;
#define IS_DMAC_BIT_WIDTH(param)          ((param) <= DMAC_WORD)

    typedef enum {
        DMAC_INC_1B = 0U,       /* address increment 1 byte */
        DMAC_INC_2B = 1U,       /* address increment 2 bytes */
        DMAC_INC_4B = 2U,       /* address increment 4 bytes */
        DMAC_INC_0B = 3U        /* address does not increase */
    } DMAC_IncWidth;
#define IS_DMAC_INCWIDTH(param)           ((param) <= DMAC_INC_0B)
#define IS_DMAC_INCWIDTH_VALID(bitwidth, incwidth)     ((bitwidth) <= (incwidth))

    typedef enum {
        DMAC_INVALID = 0U,
        DMAC_BASIC = 1U,
        DMAC_AUTOMATIC = 2U,
        DMAC_PINGPONG = 3U,
        DMAC_MEM_SCATTER_GATHER_PRI = 4U,       /* Memory scatter/gather mode (primary data) */
        DMAC_MEM_SCATTER_GATHER_ALT = 5U,       /* Memory scatter/gather mode (alternative data) */
        DMAC_PERI_SCATTER_GATHER_PRI = 6U,      /* Peripheral scatter/gather mode (primary data) */
        DMAC_PERI_SCATTER_GATHER_ALT = 7U       /* Peripheral scatter/gather mode (alternative data) */
    } DMAC_CycleCtrl;
#define IS_DMAC_CYCLECTRL(param)          ((param) <= DMAC_PERI_SCATTER_GATHER_ALT)

    typedef enum {
        DMAC_NEXT_NOT_USE_BURST = 0U,
        DMAC_NEXT_USE_BURST = 1U
    } DMAC_Next_UseBurst;
#define IS_DMAC_NEXT_USEBURST(param)      ((param) <= DMAC_NEXT_USE_BURST)

    typedef enum {
        DMAC_AFTER_1_TX = 0U,   /* Arbitration after one transfer */
        DMAC_AFTER_2_TX = 1U,   /* Arbitration after two transfer */
        DMAC_AFTER_4_TX = 2U,
        DMAC_AFTER_8_TX = 3U,
        DMAC_AFTER_16_TX = 4U,
        DMAC_AFTER_32_TX = 5U,
        DMAC_AFTER_64_TX = 6U,
        DMAC_AFTER_128_TX = 7U,
        DMAC_AFTER_256_TX = 8U,
        DMAC_AFTER_512_TX = 9U, /* Arbitration after 512 transfer */
        DMAC_NEVER = 10U        /* Do not arbitration */
    } DMAC_Arbitration;
#define IS_DMAC_ARBITRATION(param)        ((param) <= DMAC_NEVER)

#define IS_DMAC_TXNUM(param)              ((param) <= 1024U)

/** 
  * @brief  DMA Structure definition  
  */

    typedef struct {
        uint32_t SrcEndPointer; /*!< The final address of source */
        uint32_t DstEndPointer; /*!< The final address of destination */
        DMAC_CycleCtrl Mode;    /*!< Set operation mode */
        DMAC_Next_UseBurst NextUseBurst;
        uint32_t TxNum;         /*!< Set the actual number of transfers. max is 1024 */
        DMAC_Arbitration ArbitrationMoment;     /*!< Specifies the arbitration moment(R_Power)  */
        DMAC_BitWidth SrcWidth; /*!< Set source bit width */
        DMAC_IncWidth SrcInc;   /*!< Set increment of the source address */
        DMAC_BitWidth DstWidth; /*!< Set destination bit width */
        DMAC_IncWidth DstInc;   /*!< Set increment of the destination address */
    } DMAC_InitTypeDef;


/** @} */
/* End of group uDMAC_Exported_Types */

/** @defgroup uDMAC_Exported_FunctionPrototypes
  * @{
  */
    FunctionalState DMAC_GetDMACState(TSB_DMA_TypeDef * DMACx);
    void DMAC_Enable(TSB_DMA_TypeDef * DMACx);
    void DMAC_Disable(TSB_DMA_TypeDef * DMACx);
    void DMAC_SetPrimaryBaseAddr(TSB_DMA_TypeDef * DMACx, uint32_t Addr);
    uint32_t DMAC_GetBaseAddr(TSB_DMA_TypeDef * DMACx, DMAC_PrimaryAlt PriAlt);
    void DMAC_SetSWReq(TSB_DMA_TypeDef * DMACx, uint8_t Channel);
    void DMACA_SetTransferType(uint8_t Channel, DMAC_TransferType Type);
    DMAC_TransferType DMACA_GetTransferType(uint8_t Channel);
    void DMAC_SetMask(TSB_DMA_TypeDef * DMACx, uint8_t Channel, FunctionalState NewState);
    FunctionalState DMAC_GetMask(TSB_DMA_TypeDef * DMACx, uint8_t Channel);
    void DMAC_SetChannel(TSB_DMA_TypeDef * DMACx, uint8_t Channel, FunctionalState NewState);
    FunctionalState DMAC_GetChannelState(TSB_DMA_TypeDef * DMACx, uint8_t Channel);
    void DMAC_SetPrimaryAlt(TSB_DMA_TypeDef * DMACx, uint8_t Channel, DMAC_PrimaryAlt PriAlt);
    DMAC_PrimaryAlt DMAC_GetPrimaryAlt(TSB_DMA_TypeDef * DMACx, uint8_t Channel);
    void DMAC_SetChannelPriority(TSB_DMA_TypeDef * DMACx, uint8_t Channel, DMAC_Priority Priority);
    DMAC_Priority DMAC_GetChannelPriority(TSB_DMA_TypeDef * DMACx, uint8_t Channel);
    void DMAC_ClearBusErr(TSB_DMA_TypeDef * DMACx);
    Result DMAC_GetBusErrState(TSB_DMA_TypeDef * DMACx);
    void DMAC_FillInitData(TSB_DMA_TypeDef * DMACx, uint8_t Channel, DMAC_InitTypeDef * InitStruct);
/** @} */
/* End of group uDMAC_Exported_FunctionPrototype */

/** @} */
/* End of group uDMAC */

/** @} */
/* End of group TX03_Periph_Driver */

#ifdef __cplusplus
}
#endif                          /* __cplusplus */
#endif                          /* __TMPM311_uDMAC_H */
