/** 
 *******************************************************************************
 * @file    retarget.h
 * @brief   the application functions of retarget for the TOSHIBA
 *          'TMPM311' Device Series 
 * @version V0.100
 * @date    2014/10/24
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * (C)Copyright TOSHIBA ELECTRONIC DEVICES & STORAGE CORPORATION 2017 All rights reserved
 *******************************************************************************
 */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __RETARGET_H
#define __RETARGET_H
/* Includes ------------------------------------------------------------------*/

#include "tmpm311_uart.h"
#include <stdio.h>

#define  DEF_DISABLED                   0
#define  DEF_ENABLED                    1

#define     UART0_R     DEF_ENABLED     /*Set UART0 as retarget channel*/
   
#if (UART0_R == DEF_ENABLED)
    #define UART_RETARGET               UART0
    #define TSB_RETG    TSB_PA
    #define TXD_BIT     (1U<<6U)
    #define RXD_BIT     (1U<<5U)
    #define INT_RETARGET_IRQn       INTTX0_IRQn
    #define Retartget_IRQHandler    INTTX0_IRQHandler
#endif


#define BUFFER_SIZE 16U
#define SET     0x01U           /* flag is set */
#define CLEAR   0x00U           /* flag is cleared */
#define NO      0x00U           /* Send finish NG */
#define YES     0x01U           /* Send finish OK */

void Retarget_Init(void);

#endif
