/**
 *******************************************************************************
 * @file    tmpm311_tmrb_int.c
 * @brief   all interrupt request functions definition of TEMP demo
 *          for the TOSHIBA 'TMPM311' Device Series 
 * @version V0.100
 * @date    2014/10/27
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * (C)Copyright TOSHIBA ELECTRONIC DEVICES & STORAGE CORPORATION 2017 All rights reserved
 *******************************************************************************
 */
/* Includes ------------------------------------------------------------------*/
#include "TMPM311.h"
extern volatile uint8_t f1ms;
extern volatile uint8_t f1s;

/**
  * @brief  TMRB0 interrupt service routine (1ms)
  * @param  None
  * @retval None
  */
void INTTB0_IRQHandler(void)
{
    static uint16_t tbcount = 0U;
    f1ms = 1U;
    if (++tbcount >= 1000U) {
      f1s = 1U;
      tbcount = 0U;
    } else {
        /* do nothing */
    }
}

/*********************************** END OF FILE ******************************/
