/**
 *******************************************************************************
 * @file    tmpm311_tmr16a_int.c
 * @brief   all interrupt request functions definition of TMR16A_TIMER demo
 *          for the TOSHIBA 'TMPM311' Device Series 
 * @version V0.100
 * @date    2014/10/14
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * (C)Copyright TOSHIBA ELECTRONIC DEVICES & STORAGE CORPORATION 2017 All rights reserved
 *******************************************************************************
 */
/* Includes ------------------------------------------------------------------*/
#include "tmpm311_tmr16a_int.h"
#include "main.h"

/**
  * @brief  TMR16A0 interrupt service routine (0.5ms)
  * @param  None
  * @retval None
  */
void INTT16A0_IRQHandler(void)
{
    static uint16_t tbcount = 0U;
    static uint8_t ledon = 1U;

    tbcount++;
    if (tbcount >= 500U) {
        tbcount = 0U;
        /* reverse LED output */
        ledon = (ledon == 0U) ? 1U : 0U;
        if (0U == ledon) {
            LED_Off(LED_ALL);
        } else {
            LED_On(LED_ALL);
        }
    } else {
        /* do nothing */
    }
}

/*********************************** END OF FILE ******************************/
