/** 
 *******************************************************************************
 * @file    main.c
 * @brief   The application functions of UART0 Master demo for the TOSHIBA
 *          'TMPM311' Device Series 
 * @version V0.100
 * @date    2014/10/27
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * (C)Copyright TOSHIBA ELECTRONIC DEVICES & STORAGE CORPORATION 2017 All rights reserved
 *******************************************************************************
 */
#include "main.h"
#include <stdio.h>

#define BufSize (sizeof(TxBuffer) / sizeof(*(TxBuffer)))

uint8_t TxBuffer[] = "TMPM3111";
uint8_t RxBuffer[BufSize] = { 0U };

const uint8_t NumToBeTx = BufSize - 1U;

uint8_t TxCounter = 0U;
uint8_t RxCounter = 0U;

UART_InitTypeDef myUART;

void SIO_Configuration(TSB_SC_TypeDef * SCx);
void ResetIdx(void);

int main(void)
{
    SCB->VTOR = (unsigned int)0x10000000;
    /* Initialize system */
    SIO_Configuration(UART0);

    myUART.BaudRate = (uint32_t)115200;
    myUART.DataBits = UART_DATA_BITS_8;
    myUART.StopBits = UART_STOP_BITS_1;
    myUART.Parity = UART_NO_PARITY;
    myUART.Mode =  UART_ENABLE_TX|UART_ENABLE_RX;
    myUART.FlowCtrl = UART_NONE_FLOW_CTRL;
        
    UART_Enable(UART0);
    UART_Init(UART0, &myUART);

    UART_RxFIFOByteSel(UART0,UART_RXFIFO_RXFLEVEL);
    
    UART_TxFIFOINTCtrl(UART0,ENABLE);

    UART_RxFIFOINTCtrl(UART0,ENABLE);

    UART_TRxAutoDisable(UART0,UART_RXTXCNT_AUTODISABLE);
    
    UART_FIFOConfig(UART0,ENABLE); 
                
    UART_RxFIFOFillLevel(UART0,UART_RXFIFO4B_FLEVLE_4_2B);

    UART_RxFIFOINTSel(UART0,UART_RFIS_REACH_EXCEED_FLEVEL);
    
    UART_RxFIFOClear(UART0);
    
    UART_TxBufferClear(UART0);
    
    UART_TxFIFOFillLevel(UART0,UART_TXFIFO4B_FLEVLE_0_0B);

    UART_TxFIFOINTSel(UART0,UART_TFIS_REACH_NOREACH_FLEVEL);
    
    UART_TxFIFOClear(UART0); 
    
    NVIC_EnableIRQ(INTTX0_IRQn);
  
    NVIC_EnableIRQ(INTRX0_IRQn);

    
    while (1) {
       
        UART_SetTxData(UART0, (uint32_t) (TxBuffer[TxCounter++]));
        
        while (RxCounter < NumToBeTx) {
            /* Do nothing */
        }
        
#ifdef DEBUG
        printf("%s\n", RxBuffer);
#endif
        ResetIdx();
    }

}

void ResetIdx(void)
{
    uint8_t i = 0U;

    for (i = 0U; i <= RxCounter; i++) {
        RxBuffer[i] = 0U;
    }
 
    TxCounter = 0U;
    RxCounter = 0U;
    
}

void SIO_Configuration(TSB_SC_TypeDef * SCx)
{
    if (SCx == TSB_SC0) {
        TSB_PA->CR |= GPIO_BIT_6;
        TSB_PA->FR1 |= GPIO_BIT_6;
        TSB_PA->FR1 |= GPIO_BIT_5;
        TSB_PA->IE |= GPIO_BIT_5;                      
    } else {
       /* nothing */
    } 
}


/**
  * @brief  Delay some time
  * @param  None
  * @retval None
  */
void delay(void)
{
    uint32_t i = 0U;
    for(i = 0U; i<0xFFFFU; i++){
      /* Do nothing */
    }
}

#ifdef DEBUG
void assert_failed(char *file, int32_t line)
{
    printf("Err!");
    while (1) {
        __NOP();
    }
}
#endif
