/**
 *******************************************************************************
 * @file    tmpm311_uart_int.c
 * @brief   all interrupt request functions definition of UART (Serial Channel)
 *          for the TOSHIBA 'TMPM311' Device Series 
 * @version V0.100
 * @date    2014/10/27
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * (C)Copyright TOSHIBA ELECTRONIC DEVICES & STORAGE CORPORATION 2017 All rights reserved
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "tmpm311_uart_int.h"

extern const uint8_t NumToBeTx;
extern uint8_t TxBuffer[];
extern uint8_t RxBuffer[];
extern uint8_t TxCounter;
extern uint8_t RxCounter;


/**
  * @brief  The transmission interrupt request function of UART channel 0.
  * @param  None
  * @retval None
  */
void INTTX0_IRQHandler(void)
{
    volatile UART_Err err;

    if (TxCounter < NumToBeTx) {
        UART_SetTxData(UART0, TxBuffer[TxCounter++]);
    } else {
        err = UART_GetErrState(UART0);
    }
}

/**
  * @brief  The reception interrupt request function of UART channel 0.
  * @param  None
  * @retval None
  */
void INTRX0_IRQHandler(void)
{
    volatile UART_Err err;

    err = UART_GetErrState(UART0);
    if (UART_NO_ERR == err) {
        RxBuffer[RxCounter++] = (uint8_t) UART_GetRxData(UART0);
    }
}
