/**
 *******************************************************************************
 * @file    tmpm311_uart_int.c
 * @brief   all interrupt request functions definition of UART (Serial Channel)
 *          for the TOSHIBA 'TMPM311' Device Series 
 * @version V0.100
 * @date    2014/10/27
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * (C)Copyright TOSHIBA ELECTRONIC DEVICES & STORAGE CORPORATION 2017 All rights reserved
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "tmpm311_uart_int.h"


extern const uint8_t NumToBeTx1;
extern uint8_t TxBuffer1[];
extern uint8_t RxBuffer1[];
extern uint8_t TxCounter1;
extern uint8_t RxCounter1;

/**
  * @brief  The transmission interrupt request function of UART channel  0.
  * @param  None
  * @retval None
  */
void INTTX0_IRQHandler(void)
{
    volatile UART_Err err;

    if (TxCounter1 < NumToBeTx1) {
        UART_SetTxData(UART0, TxBuffer1[TxCounter1++]);
    } else {
        err = UART_GetErrState(UART0);
    }
}



/**
  * @brief  The reception interrupt request function of UART channel 0.
  * @param  None
  * @retval None
  */
void INTRX0_IRQHandler(void)
{
    volatile UART_Err err;

    err = UART_GetErrState(UART0);
    if (UART_NO_ERR == err) {
        RxBuffer1[RxCounter1++] = (uint8_t) UART_GetRxData(UART0);
    }
}

