// Grove-A（脈拍センサ）デモ表示用スケッチ（プログラム）
// Processing:ver 3.5.3 
// Date:2019.05.29    by M.T.
// ------------------------------------------------------
import processing.serial.*;

static final String COM = "COM4";  // Arduino の通信ポート名を設定する
static final int DATA_RESOLUTION = 10;   // bits
static final int RECEIVE_NUM = (DATA_RESOLUTION / 7 + 1);
static final int START_BYTE = 0xFE;
static final int END_BYTE = 0xFF;
static final int DISPLAY_NUM = 1000;
static final int DISPLAY_X_PIXEL = DISPLAY_NUM;  // X pixel
static final int DISPLAY_Y_PIXEL = 512;          // Y pixel
static final int SAMPLING_RATE = 100;    // Hz

Serial serial;

int[] data;
float  LPF, BPF;
int data_index, wave_index, value;
boolean data_flag, renew_flag;
int[] pulse_HPF, pulse_view;
int  cnt, N;
boolean running = true;
boolean Pulse = false;
boolean QS = false;
boolean firstBeat = true;
boolean secondBeat = false;

int[] rate;
int sampleCounter = 0;
int lastBeatTime = 0;
int P = 255;
int T = 255;
int thresh = 230;
int amp = 0;
int BPM, sg, Total;
int IBI = 600;

void settings() {
  size(DISPLAY_X_PIXEL, DISPLAY_Y_PIXEL, FX2D);
  smooth();
}

void setup() {
  frameRate(SAMPLING_RATE*2);

  // set up serial communication
  serial = new Serial(this, COM, 115200);
  data = new int[RECEIVE_NUM];
  data_index = 0;
  //wave_index = 0;
  data_flag = false;

  // set up pulse wave form
  pulse_HPF = new int[DISPLAY_NUM];
  pulse_view = new int[DISPLAY_NUM];

  LPF = 0;
  BPF = 0;
  cnt = 0;
  rate = new int[10];

  serial.clear();
}

void draw() {
  if (renew_flag) {
    renew_flag = false;
    renewData();
    cnt++;
    if (cnt>1) {
      background(255);
      drawData();
      cnt = 0;
      fill(240);
      rect(425, 10, 150, 40, 10);
      if (QS) {
        textSize(30);
        fill(255, 0, 0);
        text( "BPM : " + BPM, 435, 41);
      }else{
        textSize(22);
        fill(0);
        text( "Not Detected", 435, 41);
      }
    }
  }
  //println(frameRate);
}

// データ更新
void renewData() {
  value = ((data[0] & 0x07) << 7) + (data[1] & 0x7F);
  LPF = 0.9*LPF + 0.1*value;

  for (int i = 0; i < pulse_view.length - 1; i++) {
    pulse_view[i] = pulse_view[i + 1];
    pulse_HPF[i] = pulse_HPF[i + 1];
  }

  pulse_view[pulse_view.length - 1] = value * DISPLAY_Y_PIXEL / (1 << DATA_RESOLUTION);  // 生データ

  BPF = 0.75*BPF + 0.25*(value - LPF + DISPLAY_Y_PIXEL/2);    // filterd
  sg = int(BPF);
  pulse_HPF[pulse_HPF.length - 1] =  sg;

  sampleCounter += 10;                // 10ms
  N = sampleCounter - lastBeatTime;   // インターバル

  if ( sg > thresh && N > (IBI/5)*3 )  if (sg > T) T = sg;

  if ( sg < thresh && sg < P ) P = sg;

  if ( N > 250 ) {
    if ( sg < thresh &&  Pulse == false && N > (IBI/5)*3) {
      Pulse = true;
      IBI = sampleCounter - lastBeatTime;
      lastBeatTime = sampleCounter;
      if (secondBeat) {
        secondBeat = false;
        for (int i=0; i<=9; i++) {
          rate[i] = IBI;
        }
      }
      if (firstBeat) {
        firstBeat = false;
        secondBeat = true;
        return;
      }
      Total = 0;
      for (int i=0; i<9; i++) {
        rate[i] = rate[i+1];
        Total += rate[i];
      }
      rate[9] = IBI;
      Total += rate[9];
      Total /= 10;
      BPM = 60000/Total; 
      QS = true;
    }
  }

  if (sg > thresh && Pulse == true) {
    Pulse = false;
    amp = T - P;
    thresh = T - amp/2;
    P = thresh;
    T = thresh;
  }

  if (N > 2500) {
    thresh = 230;
    P = 255;
    T = 255;
    lastBeatTime = sampleCounter;
    firstBeat = true;
    secondBeat = false;
    QS = false;
    BPM = 0;
    IBI = 600;
    amp = 0;
  }
}

// 波形描画
void drawData() {
  strokeWeight(1);
  for (int i = 0; i < pulse_view.length - 1; i++) {
    stroke( 0, 0, 255);      // draw line in Blue
    line(i, pulse_view[i], (i + 1), pulse_view[i + 1]);
    stroke( 255, 0, 0);  // draw line in Red
    line(i, pulse_HPF[i], (i + 1), pulse_HPF[i + 1]);
  }

  fill(255, 0, 0);
  textSize(16);
  stroke(200);               // draw line in gray
  line(0, 0, DISPLAY_X_PIXEL, 0);
  line(0, DISPLAY_Y_PIXEL/2, DISPLAY_X_PIXEL, DISPLAY_Y_PIXEL/2);
  for (int i = 1; i < pulse_view.length/SAMPLING_RATE; i++) {
    line(i*SAMPLING_RATE, 0, i*SAMPLING_RATE, DISPLAY_Y_PIXEL-20);
    text(i+"s", i*SAMPLING_RATE-5, DISPLAY_Y_PIXEL-2);
  }
  //fill(100);
  //text( "fps = " + int(frameRate), 15, 15);
}

// シリアル受信
void serialEvent(Serial p) {
  int cmd = p.read();

  switch(cmd) {
  case START_BYTE:
    data_flag = true;
    data_index = 0;
    break;
  case END_BYTE:
    renew_flag = true;
    break;
  default:
    if (data_flag == true) {
      data[data_index] = cmd;
      data_index++;
      if (data_index >= RECEIVE_NUM) {
        data_index = 0;
        data_flag = false;
      }
    }
    break;
  }
}

// マウスで描画のポーズ/再開切替
void mousePressed() {
  if (running) {
    noLoop();
    running = false;
  } else {
    serial.clear();
    running = true;
    loop();
  }
}
