//*****************************************************************************
//
//  f2837xs_pinmux.h - Created using TI Pinmux 4.0.1530  on 2019/1/11 at 10:15:48.
//
//*****************************************************************************
//
// Copyright (C) 2017 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//
//   Redistributions of source code must retain the above copyright
//   notice, this list of conditions and the following disclaimer.
//
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the
//   documentation and/or other materials provided with the
//   distribution.
//
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//*****************************************************************************
//
//  These values will provide the functionality requested when written into
//  the registers for which the #defines are named.  For example, using the
//  C2000Ware device support header files, use the defines like in this
//  sample function:
//
//  void samplePinMuxFxn(void)
//  {
//      EALLOW;
//      //
//      // Write generated values to mux registers
//      //
//      GpioCtrlRegs.GPAMUX1.all  = GPAMUX1_VALUE;
//      GpioCtrlRegs.GPAMUX2.all  = GPAMUX2_VALUE;
//      GpioCtrlRegs.GPBMUX1.all  = GPBMUX1_VALUE;
//        . . .
//      EDIS;
//  }
//
//*****************************************************************************

#ifndef F2837XS_PINMUX_H_
#define F2837XS_PINMUX_H_

//
// Port A mux register values
//
// Pin 1 (GPIO10) to EPWM6A (mode 1)
// Pin 2 (GPIO11) to EPWM6B (mode 1)
// Pin 18 (GPIO8) to EPWM5A (mode 1)
// Pin 19 (GPIO9) to EPWM5B (mode 1)
// Pin 160 (GPIO0) to EPWM1A (mode 1)
// Pin 161 (GPIO1) to EPWM1B (mode 1)
// Pin 162 (GPIO2) to EPWM2A (mode 1)
// Pin 163 (GPIO3) to EPWM2B (mode 1)
// Pin 164 (GPIO4) to EPWM3A (mode 1)
// Pin 165 (GPIO5) to EPWM3B (mode 1)
// Pin 166 (GPIO6) to EPWM4A (mode 1)
// Pin 167 (GPIO7) to EPWM4B (mode 1)
// Pin 8 (GPIO16) to GPIO16 (mode 0)
// Pin 9 (GPIO17) to GPIO17 (mode 0)
// Pin 10 (GPIO18) to GPIO18 (mode 0)
// Pin 12 (GPIO19) to GPIO19 (mode 0)
// Pin 13 (GPIO20) to GPIO20 (mode 0)
// Pin 14 (GPIO21) to GPIO21 (mode 0)
// Pin 22 (GPIO22) to GPIO22 (mode 0)
// Pin 23 (GPIO23) to GPIO23 (mode 0)
#define GPAMUX1_MASK		0x00ffffffU
#define GPAMUX2_MASK		0x0000ffffU
#define GPAMUX1_VALUE		0x00555555U
#define GPAMUX2_VALUE		0x00000000U
#define GPAGMUX1_VALUE		0x00000000U
#define GPAGMUX2_VALUE		0x00000000U

//
// Port B mux register values
//
// Pin 83 (GPIO36) to CANRXA (mode 6)
// Pin 84 (GPIO37) to CANTXA (mode 6)
// Pin 94 (GPIO50) to GPIO50 (mode 0)
// Pin 95 (GPIO51) to GPIO51 (mode 0)
// Pin 96 (GPIO52) to GPIO52 (mode 0)
// Pin 97 (GPIO53) to GPIO53 (mode 0)
// Pin 130 (GPIO42) to SDAA (mode 6)
// Pin 131 (GPIO43) to SCLA (mode 6)
// Pin 103 (GPIO58) to SPISIMOA (mode 15)
// Pin 104 (GPIO59) to SPISOMIA (mode 15)
// Pin 105 (GPIO60) to SPICLKA (mode 15)
// Pin 107 (GPIO61) to SPISTEA (mode 15)
#define GPBMUX1_MASK		0x00f00f00U
#define GPBMUX2_MASK		0x0ff00ff0U
#define GPBMUX1_VALUE		0x00a00a00U
#define GPBMUX2_VALUE		0x0ff00000U
#define GPBGMUX1_VALUE		0x00500500U
#define GPBGMUX2_VALUE		0x00000000U

//
// Port C mux register values
//
// Pin 132 (GPIO67) to GPIO67 (mode 0)
// Pin 133 (GPIO68) to GPIO68 (mode 0)
// Pin 139 (GPIO72) to GPIO72 (mode 0)
// Pin 140 (GPIO73) to GPIO73 (mode 0)
// Pin 141 (GPIO74) to GPIO74 (mode 0)
// Pin 142 (GPIO75) to GPIO75 (mode 0)
// Pin 143 (GPIO76) to GPIO76 (mode 0)
// Pin 144 (GPIO77) to GPIO77 (mode 0)
// Pin 145 (GPIO78) to GPIO78 (mode 0)
// Pin 171 (GPIO89) to GPIO89 (mode 0)
// Pin 172 (GPIO90) to GPIO90 (mode 0)
// Pin 175 (GPIO93) to GPIO93 (mode 0)
// Pin 176 (GPIO94) to GPIO94 (mode 0)
// Pin 155 (GPIO85) to SCIRXDA (mode 5)
// Pin 154 (GPIO84) to SCITXDA (mode 5)
// Pin 157 (GPIO87) to SCIRXDB (mode 5)
// Pin 156 (GPIO86) to SCITXDB (mode 5)
#define GPCMUX1_MASK		0x3fff03c0U
#define GPCMUX2_MASK		0x3c3cff00U
#define GPCMUX1_VALUE		0x00000000U
#define GPCMUX2_VALUE		0x00005500U
#define GPCGMUX1_VALUE		0x00000000U
#define GPCGMUX2_VALUE		0x00005500U

//
// Port D mux register values
//
#define GPDMUX1_MASK		0x00000000U
#define GPDMUX2_MASK		0x00000000U
#define GPDMUX1_VALUE		0x00000000U
#define GPDMUX2_VALUE		0x00000000U
#define GPDGMUX1_VALUE		0x00000000U
#define GPDGMUX2_VALUE		0x00000000U

//
// Port E mux register values
//
#define GPEMUX1_MASK		0x00000000U
#define GPEMUX1_VALUE		0x00000000U
#define GPEGMUX1_VALUE		0x00000000U

//
// Port B analog mode register values
//
// Pin 130 (GPIO42) to SDAA (mode 6)
// Pin 131 (GPIO43) to SCLA (mode 6)
#define GPBAMSEL_MASK		0x00000c00U
#define GPBAMSEL_VALUE		0x00000000U

//*****************************************************************************
//
// Function prototype for function to write values above into their
// corresponding registers. This function is found in f2837xs_pinmux.c. Its use
// is completely optional.
//
//*****************************************************************************
extern void GPIO_setPinMuxConfig(void);

#endif /* F2837XS_PINMUX_H_ */
