/**
 ****************************************************************************
 * @file     D_Driver.h
 * @brief    Motor vector control driver Header File
 * @version  V1.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2021
 *****************************************************************************
 */
#ifndef _D_DRIVER_H
#define _D_DRIVER_H

#undef EXTERN
#ifdef DEFINE_APP
#define EXTERN
#else
#define EXTERN  extern
#endif


/*===================================================================*
      Proto Type Definition
 *===================================================================*/
EXTERN	void	D_Detect_Rotor_Position(vector_t* const _motor);
EXTERN	void	D_Control_Speed(vector_t* const _motor);
EXTERN	void	D_SetZeroCurrentByVE(vector_t* const _motor, const ipdrv_t* const _ipdrv);
EXTERN	void	D_SetZeroCurrent(vector_t* const _motor);
EXTERN	bool	D_Check_OverCurrent(q15_t _ovc, q15_t _iu, q15_t _iv, q15_t _iw);
EXTERN	void	D_Check_DetectCurrentError(vector_t* const _motor);
EXTERN	int		D_Check_DetectCurrentError_1shunt(uint32_t _pwma, uint32_t _pwmb, uint32_t _pwmc, uint16_t _chkplswidth, int _sfhpwm, int _modu, int _sector, uint32_t _mdprd);
EXTERN	int		D_Check_DetectCurrentError_3shunt(uint32_t _duty, uint16_t _chkplswidth);

#undef	EXTERN
#endif /* _D_DRIVER_H */


/*************************** END OF FILE **************************************/
