//
// IH Cooker Sample Program
//

#include"Include.h"
volatile u8 Timer10mS ;
volatile u8 Timer1mS;

volatile u8 IsrOvp  = 0;
volatile u8 IsrCmp1 = 0;
volatile u8 IsrCmp2 = 0;
volatile u8 IsrCmp3 = 0;



void __attribute (( interrupt(0x04) ))  ISR_OVP(void)
{
	IsrOvp++;

	_ovpf = 0;
	HW_State_type1.bits.Trigger=1;

	OVP_event_flag = 1;
	OVP_adj_flag = 1;
	if(bStartPPG==1)
	{
		bStartPPG = 0;
		_pst=1;
		_prsen=1;
	}
	_t2on = 0;
	_t2on = 1;
}

void __attribute( ( interrupt(0x10) ) ) ISR_tmr0 (void)
{
	Timer1mS++;
	if(Timer1mS>1)
	{
		Timer1mS =0;
		T1mS_event=1;
		AD_Convert();
		u8_I2c_WrRd_1ms++;
	}	
	_t0f = 0;
}

void __attribute( ( interrupt(0x28) ) ) ISR_tmr2 (void)
{
	if(OVP_adj_flag == 0)
	{ 
		AdjPower();
		Timer10mS = 0;
	}
    else if(OVP_adj_flag == 1)
	{
		Timer10mS++;
		if(Timer10mS==18)
		{
		    OVP_adj_flag = 0;
		    Timer10mS = 0;

		    bPowerAdjStart=1;
	    }
	}
	_t2f = 0;
}

void __attribute (( interrupt(0x08) ))  ISR_CMP1(void)
{
	IsrCmp1++;

	_cp1f=0;
	u16ErrorBuf |=0b0010000000000000;
}

void __attribute (( interrupt(0x18) ))  ISR_CMP2(void)
{
	IsrCmp2++;

	//--------------Surge-----------------------
	bSurgeHW=1;	
	ErrRecoveryTimer=c_ErrRecoveryTime;
	_cp2f=0;
}

void __attribute (( interrupt(0x1c) ))  ISR_CMP3(void)
{
	IsrCmp3++;

	//--------------OverCurrent-----------------------
	if(1==bOverCurrentHW_RE)
	{
		bOverCurrentHW_RE=0;
		if(ucOverI_S_Cnt>0 && ucOverI_S_Cnt<=3)
		{
			bErrOverCurrent=1;
			ErrRecoveryTimer=c_ErrRecoveryTime;
		}
	}
	else
	{
		bOverCurrentHW=1;
		bOverCurrentHW_RE=1;
		ErrRecoveryTimer=c_ErrRecoveryTime-2;
		ucOverI_S_Cnt=0;
	}
	_cp3f=0;
}

//DEBUG
void __attribute (( interrupt(0x30) ))  PPGTIMER(void)
{
	_ppgtmf=0;
}
