//
// IH Cooker Sample Program
//

#include"Include.h"

volatile bit Fg_Beep_State;
volatile bit Fg_Beep_ON;
volatile u8 Beep_Cnt;
volatile u8 Beep_Cmd;


void Beep_Fan_Dcf_Init() 
{
	Beep_Init();
}

void Beep_Init()
{
	//f=8MHz/2048=4kHz
	_pcken = 0;
	_pckd  = 0;
	_pckpol = 0;

	BEEP_OFF();
}

void beep_run()
{
	switch(Beep_Cmd)
	{
		case 0:
			break;
		case 1:
			Beep_Cnt=10;  //20ms*10
			Beep_Cmd=0;
			break;
		case 2:
			Beep_Cnt=10;  //20ms*10
			Fg_Beep_State=1;
			Beep_Cmd=0;
			break;
	    case 3:
			Beep_Cnt=50;  //20ms*50
			Beep_Cmd=0;
			break;
		default:
			break;
	}
}


void Beep_Task() //20ms
{
	 static u8 Beep_Off_Cnt=0;
	beep_run();
	if(Beep_Cnt!=0)
	{
		Beep_Cnt--;
		BEEP_ON();
		Fg_Beep_ON=1;
	}
	else
	{

		if(ControlSet_App.flagBit.fan)
		{
		   BEEP_OFF1();
		}
		else
		{
		   BEEP_OFF();
		}	
		Fg_Beep_ON=0;
		if(1==Fg_Beep_State)
		{
			if(++Beep_Off_Cnt>25)
			{
				Fg_Beep_State=0;
				Beep_Off_Cnt=0;
				Beep_Cmd=1;
			}
		}
	}
}
