//
// IH Cooker Sample Program
//

#ifndef	_MY_TYPE_H_
#define	_MY_TYPE_H_

typedef    unsigned char		u8;
typedef    unsigned int 	 	u16;
typedef    unsigned long 	 	u32;
typedef    unsigned long long 	u64;

typedef    signed char			s8;
typedef    signed int 	 		s16;
typedef    signed long 	 		s32;
typedef    signed long long 	s64;

typedef    unsigned char		uint8;
typedef    unsigned int 	 	uint16;
typedef    unsigned long 	 	uint32;
typedef    unsigned long long 	uint64;

typedef    signed char			int8;
typedef    signed int 	 		int16;
typedef    signed long 	 		int32;
typedef    signed long long 	int64;

#define TRUE    (1)
#define FALSE   (0)

#define ENABLE    (1)
#define DISABLE   (0)

#define ON						1
#define OFF						0


typedef struct {
unsigned char bit0 : 1;
unsigned char bit1 : 1;
unsigned char bit2 : 1;
unsigned char bit3 : 1;
unsigned char bit4 : 1;
unsigned char bit5 : 1;
unsigned char bit6 : 1;
unsigned char bit7 : 1;
}bit_type;


typedef union
{
	struct
	{      
	  u8	error  	:4;
	  u8	NoPan  	:1;
 	  u8	inverse	:3;
	}flagBit;
	u8 m_data;
}IH_Status_FLAG;

typedef union
{
	struct
	{
	  u8	fan		:1;
	  u8	beep	:2;
	  u8	on_off	:1;
	  u8	inverse	:4;
	}flagBit;
	u8 m_data;
}ControlSet_Flag;

static volatile bit_type bit_var00 __attribute__ ((at(0x080)));
static volatile bit_type bit_var01 __attribute__ ((at(0x081)));
static volatile bit_type bit_var02 __attribute__ ((at(0x082)));
static volatile bit_type bit_var03 __attribute__ ((at(0x083)));
static volatile bit_type bit_var04 __attribute__ ((at(0x084)));
static volatile bit_type bit_var05 __attribute__ ((at(0x085)));
static volatile bit_type bit_var06 __attribute__ ((at(0x086)));

#define T1mS_event  		bit_var00.bit0
#define bStartPPG			bit_var00.bit1
#define T20mS_event  		bit_var00.bit2
#define T100mS_event  		bit_var00.bit3
#define T500mS_event  		bit_var00.bit4
#define T1S_event  			bit_var00.bit5
#define bPowerState			bit_var00.bit6
#define bPanDetectedIn		bit_var00.bit7

#define bAD_StartCapture 	bit_var01.bit1
#define bPowerStepChanged 	bit_var01.bit2
#define bPowerAdjStart 		bit_var01.bit3
#define bErrOverVoltage 	bit_var01.bit4
#define bErrPowerOff		bit_var01.bit5
#define OVP_event_flag      bit_var01.bit6
#define OVP_adj_flag        bit_var01.bit7

#define bMachineOnState 	bit_var02.bit0
#define bPanDetectedOut		bit_var02.bit1
#define bIacCurve			bit_var02.bit2
#define bProtect68			bit_var02.bit3

#define bNoPAD   		   	bit_var02.bit7

#define b1s_Updata			bit_var03.bit3

#define bRlbfTemp			bit_var03.bit5
#define bOverCurrentHW_RE	bit_var03.bit6

#define bErrPAD_Otemper_ForOn 	     bit_var04.bit0
#define bErrIGBT_Otemper_ForOn 		 bit_var04.bit1

#define bPower1s			         bit_var04.bit5

#define bErrPAD_Otemper	       		 bit_var04.bit6
#define bErrIGBT_Otemper 	         bit_var04.bit7
//
#define bSurgeHW 					bit_var05.bit0
#define bOverCurrentHW 				bit_var05.bit1
#define bOverVoltageHW				bit_var05.bit2
#define bIgbtNtcError				bit_var05.bit3
#define bPadNtcError	     		bit_var05.bit4

#define bErrUnderVoltage 			bit_var05.bit6
#define bErrOverCurrent 			bit_var05.bit7

#define c_PanDetectPulseTH		12
#define PAN_DET_TIMER_100MS 	10		//10x100mS = 1.0 sec
#define c_NoPanDetectedOff		30		//20x30x100mS = 60 sec

#define c_ErrRecoveryTime		3		//second

#define V_TOLERANCE  0 
#define c_AD_70V	(45-V_TOLERANCE)
#define c_AD_75V	(48-V_TOLERANCE)
#define c_AD_80V	(52-V_TOLERANCE)
#define c_AD_90V	(58-V_TOLERANCE)
#define c_AD_100V	(65-V_TOLERANCE)
#define c_AD_110V	(71-V_TOLERANCE)
#define c_AD_120V	(77-V_TOLERANCE)
#define c_AD_130V	(84-V_TOLERANCE)
#define c_AD_140V	(87-V_TOLERANCE)
#define c_AD_145V   (94-V_TOLERANCE)
#define c_AD_150V	(97-V_TOLERANCE)
#define c_AD_160V	(103-V_TOLERANCE)
#define c_AD_170V	(110-V_TOLERANCE)
#define c_AD_180V	(116-V_TOLERANCE)
#define c_AD_185V	(119-V_TOLERANCE)

#define c_AD_190V	(123-V_TOLERANCE)
#define c_AD_195V	(126-V_TOLERANCE)
#define c_AD_200V	(129-V_TOLERANCE)
#define c_AD_205V	(132-V_TOLERANCE)
#define c_AD_210V	(135-V_TOLERANCE)
#define c_AD_215V	(139-V_TOLERANCE)
#define c_AD_220V	(142-V_TOLERANCE)
#define c_AD_225V	(145-V_TOLERANCE)
#define c_AD_230V	(148-V_TOLERANCE)
#define c_AD_235V	(152-V_TOLERANCE)
#define c_AD_240V	(155-V_TOLERANCE)

#define c_AD_245V	(158-V_TOLERANCE)
#define c_AD_250V	(161-V_TOLERANCE)
#define c_AD_260V	(168-V_TOLERANCE)
#define c_AD_270V	(174-V_TOLERANCE)
#define c_AD_275V	(177-V_TOLERANCE)
#define c_AD_285V	(184-V_TOLERANCE)


#define	c_T_PAD280	246	
#define	c_T_PAD260	236
#define c_T_PAD240	208
#define c_T_PAD235	195
#define	c_T_PAD175	188
#define	c_T_PAD170	184
#define	c_T_PAD167	181
#define	c_T_PAD160	149
#define	c_T_PAD155	119
#define	c_T_PAD150	116
#define	c_T_PAD148	108
#define	c_T_PAD130  101
#define	c_T_PAD110  92
#define	c_T_PAD108	88
#define	c_T_PAD105  82
#define	c_T_PAD100  45
#define	c_T_PAD90	35
#define	c_T_PAD60   58
#define	c_T_PAD40	17

#define c_OvertemperCnt 	5

#define c_T_IGBT110	84
#define c_T_IGBT105	130
#define c_T_IGBT100	100
#define c_T_IGBT88	144

#define c_T_IGBT85	131
#define c_T_IGBT83	150
#define c_T_IGBT78	145
#define c_T_IGBT68	166
#define c_T_IGBT65	171
#define c_T_IGBT63	176
#define c_T_IGBT52	196
#define c_T_IGBT50	199

#define c_NTC_OPENCIRCUIT  	253
#define c_NTC_SHORTCIRCUIT 	3

#define c_NTC_TIMEOUT	10
#define c_AD_MinCur		20

#define  cMoveOut_TH	100
#define  OffCurrent_TH	c_AD_MinCur

#define c_OverVoltageCnt_TH		10
#define c_UnderVoltageCnt_TH	10
#define c_OverCurrentCnt_TH		2

#define   c_5Min       60*5

#define c_PowStep_OFF	0

#define c_MaxVol	c_AD_270V
#define c_MinVol	c_AD_150V

#define  c_T_PAD_OTEMP 		c_T_PAD175
#define  c_T_PAD_OTEMP1		c_T_PAD175
#define  c_T_PAD_RECOVER	c_T_PAD60

#define c_AD_MaxCurrent		90
//
#define c_T_IGBT_POWERDROP  c_T_IGBT88
#define c_T_IGBT_POWERDROP1 c_T_IGBT83
//
#define c_T_IGBT_OTEMP 		c_T_IGBT105
#define c_T_IGBT_RECOVER    c_T_IGBT65


#endif
