// ********************************** Controller Functions ***********************************************

////-------------------------------Button Controller Functions ------------------------------------------
////Button in tab global (always visibale area)*************************
void button_comPortReset(){
  println("Button_comPortReset()");
  serialPort.stop();
  delay(50);
  serialPortInitialization();
}
void button_i2cTest(){
  cmdReadByte(0x00);
  delay(50);
  if(statusI2C==0){
    displayMessageBoxInformation("I2C Ok","I2C Connection Ok");
  }
}

void button_saveSettingFile(){
  //Getting File to save to
  selectOutput("Select a file to save Settings to:","saveSettingFunc"); //saveSettingFunc function will be called with file info
}
void saveSettingFunc(File selection){  // Saving Setting Data to File
  if(selection==null){
    println("Window was closed or the user hit cancel.");
  }else{
    //Prepare the string array representing File Format
    String[] outputData = new String[36];
    outputData[0]="typedef struct reg{";
    outputData[1]="        uint8_t address;";
    outputData[2]="        uint8_t data;";
    outputData[3]="} reg;";
    outputData[4]="";
    outputData[5]="////Register map: Data of TC78B011FTG (from Reg1 to Reg28)";
    outputData[6]="reg regmapB011[28]={";
    for(int reg=1; reg<=28; reg++){
      if(reg<28){
        outputData[6+reg]="  {0x"+hex(reg,2)+", 0x"+hex(ic.getReg(reg),2)+"},";
      }else{
        outputData[6+reg]="  {0x"+hex(reg,2)+", 0x"+hex(ic.getReg(reg),2)+"}";
      }
    }
    outputData[35]="}";
    saveStrings(selection.getAbsolutePath(),outputData);
  }
}

void button_loadSettingFile(){
  //Getting File to read from
  selectInput("Select a file to load Settings from:","loadSettingFunc"); //loadSettingFunc function will be called with file info
}
void loadSettingFunc(File selection){  // Loading Setting Data from File
  if(selection==null){
    println("Window was closed or the user hit cancel.");
  }else{
    String[] loadedData=loadStrings(selection.getAbsolutePath());
    String testStr = "////Register map: Data of TC78B011FTG (from Reg1 to Reg28)";
    //println("Loaded file length: "+loadedData.length);
    if(loadedData.length >= 36){
      if((loadedData[5].equals(testStr)==true)&&(loadedData[35].equals("}")==true)){ //Testing for valid 
          //Extracting Data from this string array
          for(int i=7; i<35; i++){
            if(debug){println(loadedData[i]);}
            int reg =i-6;
            int data=unhex(loadedData[i].substring(11,13));
            //println(loadedData[i].substring(11,13));
            ic.setReg(reg,data);              //Set data in GUI register
            cmdWriteByte(reg,data);           //send data to MCD
            delay(50);
          }
          updateControllerValuesFromRegData(); //Updates GUI controllers according to loaded data
          //Updating the text in Register Tab
          textArea_registerList.setText(ic.printRegAllInString());
          textArea_variableList.setText(ic.printVarAllInString());  
          println("File loaded successfully.");
      }else{
        displayMessageBoxError("ERROR", "Selected file is invalid.");
        println("Loaded file is invalid");
      }
    }else{
      displayMessageBoxError("ERROR", "Selected file is invalid.");
      println("Loaded file is invalid");
    }
  }
}

void button_reloadFromMcd(){
  readMcdAndUpdateGui();
  displayMessageBoxInformation("Success", "Settings are reloaded from MCD and GUI is updated");
}

////Button in tab3 (Registers)*************************
void button_ReadReg(){
  String inputAdd = cp5.get(Textfield.class,"textField_RegAdd").getText();
  int add = int(inputAdd), data;
  if(add<=30 || add==86 || add==87){ //Valid Input address
    data=cmdReadByte(add);
    delay(50);
    cp5.get(Textfield.class,"textField_RegData").setText(hex(data,2));
    if(debug){
      println("button_ReadReg  Success:  Reg:"+add+"  Data:0x"+hex(data,2));
    }
  }else{ //Invalid Input address
    println("button_ReadReg  Error:Invalid register address:"+add+"    Valid address range is (0-30,86,87)");
    displayMessageBoxError("ERROR:Invalid Register Address", "Enter a valid address (0-30,86,87)");
  }
}
void button_WriteReg(){
  String inputAdd = cp5.get(Textfield.class,"textField_RegAdd").getText();
  String inputData = cp5.get(Textfield.class,"textField_RegData").getText();
  int add = int(inputAdd), data;
  Boolean dataValidity = false;
  if(add<=30 || add==86 || add==87){ //Valid Input address
        if(inputData.length()==1){
              char c =inputData.charAt(0);
              if(((c>='0' && c<='9')||(c>='a' && c<='f')||(c>='A' && c<='F'))){
                    dataValidity = true;
              }
        }else if(inputData.length()==2){
              char l = inputData.charAt(0); //left char
              char r = inputData.charAt(1); //right char
              //println("l:"+l+"    r:"+r);
              if(((l>='0' && l<='9')||(l>='a' && l<='f')||(l>='A' && l<='F'))   &&    ((r>='0' && r<='9')||(r>='a' && r<='f')||(r>='A' && r<='F'))){
                    dataValidity = true;
              }
        }
        if(dataValidity==true){
              data=unhex(inputData);  
              cmdWriteByte(add,data);
              delay(50);
              if(add<=30){
                ic.setReg(add,data);
                updateControllerValuesFromRegData();
              }
              if(debug){
                println("button_WriteReg  Success:  Reg:"+add+"  Data:0x"+hex(data,2)+"   , GUI updated.");
              }
        }else{
              println("button_WriteReg  Error:Invalid Register Data:"+inputData+" hex    Valid data range is (0 to FF)" );
              displayMessageBoxError("ERROR:Invalid Register Data","Enter a valid data (0 to FF)");
        }
  }else{ //Invalid Input address
        println("button_WriteReg  Error:Invalid Register Address:"+add+"    Valid address range is (0-30,86,87)");
        displayMessageBoxError("ERROR:Invalid Register Address", "Enter a valid address (0-30,86,87)");
  }

}

void button_RegFieldClear(){
  cp5.get(Textfield.class,"textField_RegAdd").setText("");
  cp5.get(Textfield.class,"textField_RegData").setText("");
}

////Button in tab4 (NVM)*************************
void button_ReadNvm(){
  if(debug){
    println("button_ReadNvm    Reading NVM..."); //##
  }
  cmdWriteByte(86, 0); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cmdWriteByte(87, 1); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(100);
  boolean success=false;
  int data, count=0;
  while(success==false && count<=10){
    count++;
    data = cmdReadByte(87); // Sends command to read one byte via I2C // add:register_address // returns:read_data
    if(data==0){
      success=true;
    }else{
      delay(100);
      println("count:"+count);
    }
  }
  readMcdAndUpdateGui(); //reads all registers from MCD and updates registers in GUI and updates all controllers of GUI accordingly
  if(success==true){
    displayMessageBoxInformation("Success", "NVM Read complete");
  }else{
    displayMessageBoxError("ERROR", "NVM Read was unsuccessful");
  }
}

void button_WriteNvm(){
  if(debug){
    println("button_WriteNvm    Writing NVM..."); //##
  }
  cmdWriteByte(86, 1); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cmdWriteByte(87, 1); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(100);
  boolean success=false;
  int data, count=0;
  while(success==false && count<=10){
    count++;
    data = cmdReadByte(87); // Sends command to read one byte via I2C // add:register_address // returns:read_data
    if(data==0){
      success=true;
    }else{
      delay(100);
      println("count:"+count);
    }
  }
  if(success==true){
    displayMessageBoxInformation("Success", "NVM Write complete");
  }else{
    displayMessageBoxError("ERROR", "NVM Write was unsuccessful");
    //Problem in Writing NVM so Forcing the writing process to stop
    cmdWriteByte(87, 0); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  }
  cp5.getController("button_WriteNvm").setVisible(false);
  cp5.getController("toggle_WriteNvmConfirm").changeValue(0);
}

////---------------------------------- ScrollableList (Dropdown) Controller Functions -------------------------------------
//// ScrollableList in Global (always visible area) ********************************
void scrollableList_I2CAddressSelect(int value){
  println("scrollableListI2CAddressSelect :"+value);
  switch(value){
    case 0: //I2C address : Reg (Set custom value) // This value must be same as set in MCD register 25[7:1]
      boolean validAddress = false;
      while(validAddress==false){
          String i2cAddStr = displayMessageBoxInputString("I2C Address", "Enter MCD I2C address (00 to 7F)");
          if(i2cAddStr!=null){
            try{
              if(i2cAddStr.length()==2){
                char l = i2cAddStr.charAt(0);
                char r = i2cAddStr.charAt(1);
                println("l:"+l+"    r:"+r);
                if((l>='0' && l<='7') && ((r>='0' && r<='9')||(r>='a' && r<='f')||(r>='A' && r<='F'))){
                  cmdSetId(unhex(i2cAddStr));  //Setting I2C address in USB-I2C Converter
                  delay(50);
                  textI2CRegAddress="0x"+i2cAddStr;
                  validAddress=true;
                }else{
                  println("Error: Entered I2C address is invalid: "+i2cAddStr);
                  displayMessageBoxError("ERROR: Invalid I2C Address","Enter a valid I2C address (00 to 7F)");
                }
              }else{
                println("Error: Entered I2C address is invalid: "+i2cAddStr);
                displayMessageBoxError("ERROR: Invalid I2C Address","Enter a valid I2C address (00 to 7F)");
              }
            }catch(Exception e){
              println("Error: Entered I2C address is invalid: "+i2cAddStr);
              displayMessageBoxError("ERROR: Invalid I2C Address","Enter a valid I2C address (00 to 7F)");
            }
          }else{
            println("Error: I2C address is not entered.");
            displayMessageBoxError("ERROR: Invalid I2C Address","Enter a valid I2C address (00 to 7F)");
          }  
      }
      break;
    case 1: //I2C address : 0x29
      cmdSetId(0x29);
      delay(50);
      textI2CRegAddress="";
      break;    
    case 2: //I2C address : 0x2D
      cmdSetId(0x2D);
      delay(50);
      textI2CRegAddress="";
      break;
    case 3: //I2C address : 0x32
      cmdSetId(0x32);
      delay(50);
      textI2CRegAddress="";
      break;
  }

}

//// ScrollableList in Tab default (Configuration Control) ********************************
void scrollableList_LeadAngle(int value){
  ic.setVar(ic.la, value); //** set the variableData in corresponding register
  if(debug){
    println("scrollableList_LeadAngle   reg:"+value); //##
    ic.printVar(ic.la);   //** Print a single variable
  }
  int reg = ic.la.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void scrollableList_Fpwm(int value){
  ic.setVar(ic.fpwm, value); //** set the variableData in corresponding register
  if(debug){
    println("scrollableList_FPW   reg:"+value); //##
    ic.printVar(ic.fpwm);   //** Print a single variable
  }
  int reg = ic.fpwm.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void scrollableList_Fmax(int value){
  ic.setVar(ic.fmax, value); //** set the variableData in corresponding register
  if(debug){
    println("scrollableList_Fmax   reg:"+value); //##
    ic.printVar(ic.fmax);   //** Print a single variable
  }
  int reg = ic.fmax.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void scrollableList_LockStatus(int value){
  ic.setVar(ic.lock_brk, value); //** set the variableData in corresponding register
  if(debug){
    println("scrollableList_LockStatus   reg:"+value); //##
    ic.printVar(ic.lock_brk);   //** Print a single variable
  }
  int reg = ic.lock_brk.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void scrollableList_Isdlevel(int value){
  ic.setVar(ic.isd_lvl, value); //** set the variableData in corresponding register
  if(debug){
    println("scrollableList_Isdlevel   reg:"+value); //##
    ic.printVar(ic.isd_lvl);   //** Print a single variable
  }
  int reg = ic.isd_lvl.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void scrollableList_MaskTime(int value){
  ic.setVar(ic.ocpmask, value); //** set the variableData in corresponding register
  if(debug){
    println("scrollableList_MaskTime   reg:"+value); //##
    ic.printVar(ic.ocpmask);   //** Print a single variable
  }
  int reg = ic.ocpmask.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void scrollableList_OcpLevel(int value){
  ic.setVar(ic.ocp_lvl, value); //** set the variableData in corresponding register
  if(debug){
    println("scrollableList_OcpLevel   reg:"+value); //##
    ic.printVar(ic.ocp_lvl);   //** Print a single variable
  }
  int reg = ic.ocp_lvl.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void scrollableList_RsaFilter(int value){
  ic.setVar(ic.rs_sel, value); //** set the variableData in corresponding register
  if(debug){
    println("scrollableList_RsaFilter   reg:"+value); //##
    ic.printVar(ic.rs_sel);   //** Print a single variable
  }
  int reg = ic.rs_sel.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

//// ScrollableList in Tab2 (Motor Control) ********************************
void scrollableList_PolePairs(int value){
  ic.setVar(ic.polepair, value); //** set the variableData in corresponding register
  if(debug){
    println("scrollableList_PolePairs=" + (value*2+2) + "   reg:"+value); //**
    ic.printVar(ic.polepair);   //** Print a single variable
  }
  int reg = ic.polepair.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void scrollableList_MaxSpeed(int value){
  ic.setVar(ic.maxspeed, value); //** set the variableData in corresponding register
  if(debug){
    println("scrollableList_MaxSpeed=" + value); //**
    ic.printVar(ic.maxspeed);   //** Print a single variable
  }
  int reg = ic.maxspeed.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void scrollableList_FGSEL(int value){
  ic.setVar(ic.fgsel, value); //** set the variableData in corresponding register
  if(debug){
    println("scrollableList_FGSEL=" + value); //**
    ic.printVar(ic.fgsel);   //** Print a single variable
  }
  int reg = ic.fgsel.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void scrollableList_RPM_Limit(int value){
  ic.setVar(ic.rpmlimit, value); //** set the variableData in corresponding register
  if(debug){
    println("scrollableList_RPM_Limit=" + value); //**
    ic.printVar(ic.rpmlimit);   //** Print a single variable
  }
  int reg = ic.rpmlimit.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}


////---------------------------------- SLIDER Controller Functions -------------------------------------
//// Slider in Tab default (Configuration Control) ********************************
void slider_SourceCurrent(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.source,regValue);  //**
  if(debug){
    println("slider_SourceCurrent ="+sourceCurrentData[int(value)]+ "    forReg="+regValue); //##
    ic.printVar(ic.source);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.source.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_SinkCurrent(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.sink,regValue);  //**
  if(debug){
    println("slider_SinkCurrent ="+sinkCurrentData[int(value)]+ "    forReg="+regValue); //##
    ic.printVar(ic.sink);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.sink.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_DutyChangeLimit(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.dutychglimit,regValue);  //**
  if(debug){
    println("slider_DutyChangeLimit ="+dutyChangeLimitData[int(value)]+ "    forReg="+regValue); //##
    ic.printVar(ic.dutychglimit);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.dutychglimit.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_DutyChangeTime(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.duty_up_time,regValue);  //**
  if(debug){
    println("slider_DutyChangeTime ="+dutyChangeTimeData[int(value)]+ "    forReg="+regValue); //##
    ic.printVar(ic.duty_up_time);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.duty_up_time.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_DeadTime(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.deadtime,regValue);  //**
  if(debug){
    println("slider_DeadTime ="+deadTimeData[int(value)]+ "    forReg="+regValue); //##
    ic.printVar(ic.deadtime);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.deadtime.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_RestartTime(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.tre,regValue);  //**
  if(debug){
    println("slider_RestartTime ="+restartTimeData[int(value)]+ "    forReg="+regValue); //##
    ic.printVar(ic.tre);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.tre.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

//// Slider in Tab1  (Sequence Control) ********************************
void slider_FirstDcExcitation(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.pretip,regValue);  //**
  if(debug){
    println("slider_FirstDcExcitation ="+firstDcExcitationData[int(value)]+ "    forReg="+regValue); //##
    ic.printVar(ic.pretip);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.pretip.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_SecondDcExcitation(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.tip,regValue);  //**
  if(debug){
    println("slider_SecondDcExcitation ="+secondDcExcitationData[int(value)]+ "    forReg="+regValue); //##
    ic.printVar(ic.tip);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.tip.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_ForcedFreq(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.fst,regValue);  //**
  if(debug){
    println("slider_ForcedFreq ="+forcedFreqData[int(value)]+ "    forReg="+regValue); //##
    ic.printVar(ic.fst);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.fst.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_CompHys(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.comp_hys,regValue);  //**
  if(debug){
    println("slider_CompHys ="+compHysData[int(value)]+ "    forReg="+regValue); //##
    ic.printVar(ic.comp_hys);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.comp_hys.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_StartCurrent(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.startcurrent,regValue);  //**
  if(debug){
    println("slider_StartCurrent ="+startCurrentData[int(value)]+ "    forReg="+regValue); //##
    ic.printVar(ic.startcurrent);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.startcurrent.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_TargetCurrent(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.ss_add_sel,regValue);  //**
  if(debug){
    println("slider_TargetCurrent ="+targetCurrentData[int(value)]+ "    forReg="+regValue); //##
    ic.printVar(ic.ss_add_sel);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.ss_add_sel.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_CurrentIncr(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.ss_up_sel,regValue);  //**
  if(debug){
    println("slider_CurrentIncr ="+currentIncrData[int(value)]+ "    forReg="+regValue); //##
    ic.printVar(ic.ss_up_sel);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.ss_up_sel.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_SoftStartDuty(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.ss_dutychglimit,regValue);  //**
  if(debug){
    println("slider_SoftStartDuty ="+sStartDutyData[int(value)]+ "    forReg="+regValue); //##
    ic.printVar(ic.ss_dutychglimit);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.ss_dutychglimit.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_WaitTime(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.wait_time,regValue);  //**
  if(debug){
    println("slider_WaitTime ="+waitTimeData[int(value)]+ "    forReg="+regValue); //##
    ic.printVar(ic.wait_time);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.wait_time.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}


//// Slider in Tab2 (Motor Control) ********************************
void slider_StartDuty(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value*512/100);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.startduty,regValue);  //**
  if(debug){
    println("slider_StartDuty    %="+nf(value,0,2) + "    forReg="+regValue); //**
    ic.printVar(ic.startduty);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.startduty.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  //Sending Slope Data
  sendSlopeData();
}

void slider_StopDuty(float value){  // <startDuty
  // Calculating the values which will go into register
  int regValue = round(value*256/100);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.stopduty,regValue);  //**
  if(debug){
    println("slider_StopDuty    %="+nf(value,0,2) + "    forReg="+regValue); //**
    ic.printVar(ic.stopduty);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.stopduty.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_MaxDuty(float value){    
  // Calculating the values which will go into register
  int regValue = round(value*512/100-257);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.maxduty,regValue);  //**
  if(debug){
    println("slider_MaxDuty    %="+nf(value,0,2) + "    forReg="+regValue); //**
    ic.printVar(ic.maxduty);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.maxduty.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  //Sending Slope Data
  sendSlopeData();
}

void slider_ChangeDuty(float value){    
  // Calculating the values which will go into register
  int regValue = round(value*256/100);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.changeduty,regValue);  //**
  if(debug){
    println("slider_ChangeDuty    %="+nf(value,0,2) + "    forReg="+regValue); //**
    ic.printVar(ic.changeduty);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.changeduty.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  //Sending Slope Data
  sendSlopeData();
}

void slider_MinOutputOL(float value){  
  // Calculating the values which will go into register
  int regValue = round(value*512/100*16);     //** //Calculating Register value from input data //Shifted left by 4 because reg[4:0] needs to be empty in OpenLoop
  //setting value in register
  ic.setVar(ic.startrpm,regValue);  //**
  if(debug){
    println("slider_MinOutputOL    %="+nf(value,0,2) + "    forReg STARTRPM[11:4]="+regValue/16+"(0x"+hex(regValue/16,2)+")    forReg STARTRPM[11:0]="+regValue); //**
    ic.printVar(ic.startrpm);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.startrpm.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  //Sending Slope Data
  sendSlopeData();
}

void slider_MinOutputCL(float value){  
  // Calculating the values which will go into register
  int regValue = round(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.startrpm,regValue);  //**
  if(debug){
    println("slider_MinOutputCL    RPM="+nf(value,0,0) + "    forReg[11:0]="+regValue); //**
    ic.printVar(ic.startrpm);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.startrpm.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  data = ic.getReg(reg+1);
  cmdWriteByte(reg+1, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  //Sending Slope Data
  sendSlopeData();
}

void slider_MaxOutputOL(float value){   
  println("slider_MaxOutputOL %: "+nf(value,0,1));
  sendSlopeData();
}

void slider_MaxOutputCL(float value){   
  println("slider_MaxOutputCL RPM: "+nf(value,0,0));
  sendSlopeData();
}

void slider_ChangeOutputOL(float value){   
  println("slider_ChangeOutputOL %: "+nf(value,0,1));
  sendSlopeData();
}

void slider_ChangeOutputCL(float value){   
  println("slider_ChangeOutputCL RPM: "+nf(value,0,0));
  sendSlopeData();
}

void sendSlopeData(){
  int regSlope, regSlope2;
  // Slope Setting
  int maxSlope=16; //16 in Openloop    1280 in CloseLoop
  if(openLoopFlag==false){ //CloseLoop
    maxSlope=1280;
  }
  if(slopeData<0){                    //## //Invalid Data
    regSlope = 0;    
  }else if(slopeData>maxSlope){             //## //Invalid Data
    if(openLoopFlag==true){
      regSlope = round(maxSlope*1024);    //##
    }else{
      regSlope = round(maxSlope*100/8);    //## 
    }
  }else{
    if(openLoopFlag==true){
      regSlope = round(slopeData*1024);    //## //Valid Data
    }else{
      regSlope = round(slopeData*100/8);    //## //Valid Data
    }
  }
  if(slope2Data<0){                    //## //Invalid Data
    regSlope2 = 0;    
  }else if(slope2Data>maxSlope){             //## //Invalid Data
    if(openLoopFlag==true){
      regSlope2 = round(maxSlope*1024);    //## 
    }else{
      regSlope2 = round(maxSlope*100/8);    //##
    }
  }else{
    if(openLoopFlag==true){
      regSlope2 = round(slope2Data*1024);    //## //Valid Data
    }else{
      regSlope2 = round(slope2Data*100/8);    //## //Valid Data
    }
  }
  ic.setVar(ic.speedslop,regSlope);  //##
  if(threePointProfile==true){
    ic.setVar(ic.speedslop2,regSlope2); //##
  }
  if(debug){
    if(threePointProfile==false){
      println("sendSlopeData()    Slope="+nf(slopeData,0,2)+" forReg="+regSlope); //**
      ic.printVar(ic.speedslop);       //## Print a single variable
    }else{
      println("sendSlopeData()    Slope="+nf(slopeData,0,2)+" forReg="+regSlope +  "     Slope2="+nf(slope2Data,0,2)+" forReg="+regSlope2); //**
      ic.printVar(ic.speedslop);       //## Print a single variable
      ic.printVar(ic.speedslop2);    //## Print a single variable
    }
  }
  //Sending Data of change in slope becuase of change due to this controller
  int reg = ic.speedslop.REGISTER; //## //Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);     // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  data = ic.getReg(reg+1);     //Getting data of register of this variable
  cmdWriteByte(reg+1, data);   // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  if(threePointProfile==true){
    //Sending Data of change in slope2 becuase of change due to this controller
    reg = ic.speedslop2.REGISTER; //## //Getting register number of this variable
    data = ic.getReg(reg);        //Getting data of register of this variable
    cmdWriteByte(reg, data);      // Sends command to write one byte via I2C // add:register_address, data:data_to_write
    delay(50);
    data = ic.getReg(reg+1);      //Getting data of register of this variable
    cmdWriteByte(reg+1, data);    // Sends command to write one byte via I2C // add:register_address, data:data_to_write
    delay(50);
  }
}


void slider_MaxDutyHysteresis(float value){ 
  // Calculating the values which will go into register
  int regValue = round((value-0.4)/0.4);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.maxdutyhys,regValue);  //**
  if(debug){
    println("slider_MaxDutyHysteresis    %="+nf(value,0,1) + "    forReg="+regValue); //##
    ic.printVar(ic.maxdutyhys);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.maxdutyhys.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_KP(float value){ 
  // Calculating the values which will go into register
  int regValue = int(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.kp,regValue);  //**
  if(debug){
    println("slider_KP ="+nf(value,0,1) + "    forReg="+regValue); //##
    ic.printVar(ic.kp);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.kp.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_KI(float value){ 
  // Calculating the values which will go into register
  int regValue = int(value);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.ki,regValue);  //**
  if(debug){
    println("slider_KI ="+nf(value,0,1) + "    forReg="+regValue); //##
    ic.printVar(ic.ki);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.ki.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

void slider_SPD(float value){ 
  // Calculating the values which will go into register
  int regValue = round(value*512/100);     //** //Calculating Register value from input data
  //setting value in register
  ic.setVar(ic.spd,regValue);  //**
  if(debug){
    println("slider_SPD    %="+nf(value,0,2) + "    forReg="+regValue); //##
    ic.printVar(ic.spd);       //** Print a single variable    
  }
  //Sending Data of this controller
  int reg = ic.spd.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg);       //Getting data of register of this variable
  cmdWriteByte(reg, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  data=ic.getReg(reg+1);
  cmdWriteByte(reg+1, data);         // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
}

////----------------------------------- Toggle Controller Functions ------------------------------------
//// Toggle in Tab default (Configuration Control) ********************************
void toggle_SpeedControl(int value){
  ic.setVar(ic.tspsel, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_SpeedControl=" + value); //##
    ic.printVar(ic.tspsel);   //** Print a single variable
  }
  int reg = ic.tspsel.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_SpeedControl").setMouseOver(false); //**
}

void toggle_DirControl(int value){
  ic.setVar(ic.dir, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_DirControl=" + value); //##
    ic.printVar(ic.dir);   //** Print a single variable
  }
  int reg = ic.dir.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_DirControl").setMouseOver(false); //**
}

void toggle_Brake(int value){
  ic.setVar(ic.brk_inv, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_Brake=" + value); //##
    ic.printVar(ic.brk_inv);   //** Print a single variable
  }
  int reg = ic.brk_inv.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_Brake").setMouseOver(false); //**
}

void toggle_SpeedControlInverse(int value){
  ic.setVar(ic.spdinv, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_SpeedControlInverse=" + value); //##
    ic.printVar(ic.spdinv);   //** Print a single variable
  }
  int reg = ic.spdinv.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_SpeedControlInverse").setMouseOver(false); //**
}

void toggle_DisableAntiTrought(int value){
  ic.setVar(ic.antithrough, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_DisableAntiTrought=" + value); //##
    ic.printVar(ic.antithrough);   //** Print a single variable
  }
  int reg = ic.antithrough.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_DisableAntiTrought").setMouseOver(false); //**
}

void toggle_AlertInverse(int value){
  ic.setVar(ic.alertinv, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_AlertInverse=" + value); //##
    ic.printVar(ic.alertinv);   //** Print a single variable
  }
  int reg = ic.alertinv.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_AlertInverse").setMouseOver(false); //**
}

void toggle_OcpMask(int value){
  ic.setVar(ic.ocpdis, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_OcpMask=" + value); //##
    ic.printVar(ic.ocpdis);   //** Print a single variable
  }
  int reg = ic.ocpdis.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_OcpMask").setMouseOver(false); //**
}

void toggle_IsdMask(int value){
  ic.setVar(ic.isd_mask, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_IsdMask=" + value); //##
    ic.printVar(ic.isd_mask);   //** Print a single variable
  }
  int reg = ic.isd_mask.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_IsdMask").setMouseOver(false); //**
}

void toggle_TsdMask(int value){
  ic.setVar(ic.tsd_mask, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_TsdMask=" + value); //##
    ic.printVar(ic.tsd_mask);   //** Print a single variable
  }
  int reg = ic.tsd_mask.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_TsdMask").setMouseOver(false); //**
}

void toggle_LockMask(int value){
  ic.setVar(ic.lockdis, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_LockMask=" + value); //##
    ic.printVar(ic.lockdis);   //** Print a single variable
  }
  int reg = ic.lockdis.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_LockMask").setMouseOver(false); //**
}

void toggle_VcpMask(int value){
  ic.setVar(ic.vcp_mask, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_VcpMask=" + value); //##
    ic.printVar(ic.vcp_mask);   //** Print a single variable
  }
  int reg = ic.vcp_mask.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_VcpMask").setMouseOver(false); //**
}

void toggle_RecoveryMode(int value){
  ic.setVar(ic.latch, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_RecoveryMode=" + value); //##
    ic.printVar(ic.latch);   //** Print a single variable
  }
  int reg = ic.latch.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_RecoveryMode").setMouseOver(false); //**
}

//// Toggle in Tab1 (Sequence Control) ********************************
void toggle_StandbyMode(int value){
  ic.setVar(ic.stby_mode, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_StandbyMode=" + value); //##
    ic.printVar(ic.stby_mode);   //** Print a single variable
  }
  int reg = ic.stby_mode.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_StandbyMode").setMouseOver(false); //##
}

void toggle_WaitMode(int value){
  ic.setVar(ic.wait_mode, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_WaitMode=" + value); //##
    ic.printVar(ic.wait_mode);   //** Print a single variable
  }
  int reg = ic.wait_mode.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_WaitMode").setMouseOver(false); //##
}

void toggle_AfterWait(int value){
  ic.setVar(ic.wait_con, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_AfterWait=" + value); //##
    ic.printVar(ic.wait_con);   //** Print a single variable
  }
  int reg = ic.wait_con.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_AfterWait").setMouseOver(false); //##
}



//// Toggle in Tab2 (Motor Control) ********************************
void toggle_OpenCloseLoop(int value){
  ic.setVar(ic.openloop, value); //set the variableData in corresponding register
  if(debug){
    println("toggle_OpenCloseLoop=" + value);
    ic.printVar(ic.openloop);   //Print a single variable
  }
  int reg = ic.openloop.REGISTER; //Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_OpenCloseLoop").setMouseOver(false);
  ////Setting values of yaxis sliders based on Register values
  if(value==1){  //OpenLoop
    float slopeOL=float(ic.getVar(ic.speedslop))/1024;
    //println("reg:"+ic.getVar(ic.speedslop)+"   slope:"+slopeOL);
    cp5.getController("slider_MinOutputOL").changeValue((ic.getVar(ic.startrpm))*100/16/512);
    if(threePointProfile==false){
      //y=mx+c
      cp5.getController("slider_MaxOutputOL").changeValue(cp5.getController("slider_MinOutputOL").getValue()+slopeOL*(cp5.getController("slider_MaxDuty").getValue()-cp5.getController("slider_StartDuty").getValue()));
    }else{
      float slope2OL=float(ic.getVar(ic.speedslop2))/1024;
      //println("reg:"+ic.getVar(ic.speedslop2)+"   slope2OL:"+slope2OL);
      cp5.getController("slider_ChangeOutputOL").changeValue(cp5.getController("slider_MinOutputOL").getValue()+slopeOL*(cp5.getController("slider_ChangeDuty").getValue()-cp5.getController("slider_StartDuty").getValue()));
      cp5.getController("slider_MaxOutputOL").changeValue(cp5.getController("slider_ChangeOutputOL").getValue()+slope2OL*(cp5.getController("slider_MaxDuty").getValue()-cp5.getController("slider_ChangeDuty").getValue()));
    }
  }else{
    float slopeCL=float(ic.getVar(ic.speedslop))*8/100;
    //println("reg:"+ic.getVar(ic.speedslop)+"   slopeCL:"+slopeCL);
    cp5.getController("slider_MinOutputCL").changeValue(ic.getVar(ic.startrpm));
    if(threePointProfile==false){
      cp5.getController("slider_MaxOutputCL").changeValue(cp5.getController("slider_MinOutputCL").getValue()+slopeCL*(cp5.getController("slider_MaxDuty").getValue()-cp5.getController("slider_StartDuty").getValue()));
    }else{
      float slope2CL=float(ic.getVar(ic.speedslop2))*8/100;
      //println("reg:"+ic.getVar(ic.speedslop2)+"   slope2OL:"+slope2CL);
      cp5.getController("slider_ChangeOutputCL").changeValue(cp5.getController("slider_MinOutputCL").getValue()+slopeCL*(cp5.getController("slider_ChangeDuty").getValue()-cp5.getController("slider_StartDuty").getValue()));
      cp5.getController("slider_MaxOutputCL").changeValue(cp5.getController("slider_ChangeOutputCL").getValue()+slope2CL*(cp5.getController("slider_MaxDuty").getValue()-cp5.getController("slider_ChangeDuty").getValue()));
    }
  }
}

void toggle_NoStop(int value){
  ic.setVar(ic.nostop, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_NoStop=" + value); //**
    ic.printVar(ic.nostop);   //** Print a single variable
  }
  int reg = ic.nostop.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_NoStop").setMouseOver(false); //**
}

void toggle_MaxOff(int value){
  ic.setVar(ic.maxoff, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_MaxOff=" + value); //**
    ic.printVar(ic.maxoff);   //** Print a single variable
  }
  int reg = ic.maxoff.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_MaxOff").setMouseOver(false); //**
}

void toggle_MaxOpen(int value){
  ic.setVar(ic.maxopen, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_MaxOpen=" + value); //**
    ic.printVar(ic.maxopen);   //** Print a single variable
  }
  int reg = ic.maxopen.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_MaxOpen").setMouseOver(false); //**
}

void toggle_ChangePoint(int value){  //When = 1(En) set slider to [average of start spd and Max spd] and slider will send data of changeduty //When =0(Disable) send data of changeduty=0 and try to disable related sliders 
  float x;
  float per=0.8;
  if(value==0){ //disbale// set changeduty=0
    ic.setVar(ic.changeduty, 0); //** set the variableData in corresponding register
  }else{ //enable //set changeDuty to little less than maxDuty (to avoid invalid slope setting)
    ic.setVar(ic.changeduty, round(256*per)); //** set the variableData in corresponding register
    x = round((cp5.getController("slider_MaxDuty").getValue())*per);
    cp5.getController("slider_ChangeDuty").changeValue(x);
    if(openLoopFlag==true){ //OpenLoop
      x = round((cp5.getController("slider_MaxOutputOL").getValue())*(per-0.1));
      cp5.getController("slider_ChangeOutputOL").changeValue(x); 
    }else{
      x = round((cp5.getController("slider_MaxOutputCL").getValue())*(per-0.1));
      cp5.getController("slider_ChangeOutputCL").changeValue(x); 
    }
    println(x);
  }
  if(debug){
    if(value==0){
      println("toggle_ChangePoint=Disabled,  ChangeDuty is set to 0%");
    }else{
      println("toggle_ChangePoint=Enabled,   ChangeDuty="+per*100+"% of MaxDuty    and ChangeOutput="+(per-0.1)*100+"% of MaxOutput"); //**
    }
    ic.printVar(ic.changeduty);   //** Print a single variable
  }
  int reg = ic.changeduty.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  sendSlopeRegDataFlag=true;  //Send the updated slope data because changeduty has changed
  cp5.getController("toggle_ChangePoint").setMouseOver(false); //**
}


void toggle_KPX(int value){
  ic.setVar(ic.kpx, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_KPX=" + value); //**
    ic.printVar(ic.kpx);   //** Print a single variable
  }
  int reg = ic.kpx.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_KPX").setMouseOver(false); //**
}

void toggle_KIX(int value){
  ic.setVar(ic.kix, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_KIX=" + value); //**
    ic.printVar(ic.kix);   //** Print a single variable
  }
  int reg = ic.kix.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_KIX").setMouseOver(false); //**
}

void toggle_FG_ON(int value){
  ic.setVar(ic.fg_on, value); //** set the variableData in corresponding register
  if(debug){
    println("toggle_FG_ON=" + value); //**
    ic.printVar(ic.fg_on);   //** Print a single variable
  }
  int reg = ic.fg_on.REGISTER; //** Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_FG_ON").setMouseOver(false); //**
}

void toggle_AlertInv(int value){  //Reg19[1]
  ic.setVar(ic.alertinv, value); //set the variableData in corresponding register
  if(debug){
    println("toggle_AlertInv=" + value);
    ic.printVar(ic.alertinv);   //Print a single variable
  }
  int reg = ic.alertinv.REGISTER; //Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_AlertInv").setMouseOver(false);
}

void toggle_Dir(int value){
  ic.setVar(ic.dir, value); //set the variableData in corresponding register
  if(debug){
    println("toggle_Dir="+value);
    ic.printVar(ic.dir);   //Print a single variable
  }
  int reg = ic.dir.REGISTER; //Getting register number of this variable
  int data = ic.getReg(reg); //Getting data of register of this variable
  cmdWriteByte(reg, data); // Sends command to write one byte via I2C // add:register_address, data:data_to_write
  delay(50);
  cp5.getController("toggle_Dir").setMouseOver(false);
}

////Toggle in tab4 (NVM)*************************
void toggle_WriteNvmConfirm(boolean value){
     cp5.getController("button_WriteNvm").setVisible(value);
}
