/**
 *******************************************************************************
 * @file    TMPM4KyA.h
 * @brief   CMSIS Cortex-M4 Core Peripheral Access Layer Header File for the
 *          TOSHIBA 'TMPM4Ky' Group
 * @version V1.0.0.0
 * $Date:: 2020-09-10 #$
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2023
 *******************************************************************************
 */
#ifndef __TMPM4KYA_H__
#define __TMPM4KYA_H__

#ifdef __cplusplus
extern "C" {
#endif

/** @addtogroup TOSHIBA_TXZ_MICROCONTROLLER TOSHIBA TXZ MICROCONTROLLER
  * @{
  */
  
/** @addtogroup TMPM4KyA TMPM4KyA
  * @{
  */

#if !defined(TMPM4KHA) && !defined(TMPM4KLA) && !defined(TMPM4KMA) && !defined(TMPM4KNA)
/**
  * @brief Remove a comment of target device.
  */
  	/* #define TMPM4KHA */  /*!< TMPM4KHA device */
	 #define TMPM4KLA   /*!< TMPM4KLA device */
	/* #define TMPM4KMA */  /*!< TMPM4KMA device */
   	/*#define TMPM4KNA  */   /*!< TMPM4KNA device */
#endif

/** @defgroup Device_Included Device Included
  * @{
  */
#if defined(TMPM4KHA)
	#include "TMPM4KHA.h"
#elif defined(TMPM4KLA)
	#include "TMPM4KLA.h"
#elif defined(TMPM4KMA)
	#include "TMPM4KMA.h"
#elif defined(TMPM4KNA)
	#include "TMPM4KNA.h"
#else
	#error "target device is non-select."
#endif

/**
  * @}
  */ /* End of group Device_Included */

#ifdef __cplusplus
}
#endif

#endif  /* __TSB_CMSIS_CORE_H__ */

/**
  * @}
  */ /* End of group TMPM4KyA TMPM4KyA */

/**
  * @}
  */ /* End of group TOSHIBA_TXZ_MICROCONTROLLER */
