/**
 ****************************************************************************
 * @file	 D_Para_Fan.h
 * @brief	 Motor vector control Parameter Header File for FAN
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2023
 *****************************************************************************
 */
#ifndef _D_PARA_FAN_H
#define _D_PARA_FAN_H
#undef __TYPE_LOW_VOLT
#undef __TYPE_HIGH_VOLT
#undef USE_FAN_MOTOR

/*===================================================================*
	  Select Board type
 *===================================================================*/
/* #define	  __TYPE_LOW_VOLT	*/					/* Low voltage board */
#define __TYPE_HIGH_VOLT							/* High voltage board */

/*===================================================================*
	  Select parts
 *===================================================================*/
/* #define	  __USE_ENCODER_FAN */					/* If define __USE_ENCODER, use encoder */
#define __USE_VE_FAN								/* If define __USE_VE, use Vector Engine */

/*===================================================================*
	  Board Parameter Definition
 *===================================================================*/

/******** A/C 3in1 High voltage board **********************/
#if defined(__TYPE_HIGH_VOLT)

/* High/Low side driver logic */
#define cPOLH_FAN						(1)			/* High side	 0:Low active, 1:High active */
#define cPOLL_FAN						(1)			/* Low	side	 0:Low active, 1:High active */

/* V MAX */
#define cV_MAX_FAN						(522.0f)	/* [V] Input voltage(Vdc)  at ADC =0xFFF0(5V) */

/* A MAX */
#define cA_MAX_FAN						(2.0f)		/* [A] Input current(Iabc) at ADC =0xFFF0(5V) */

#endif

/* Current detection Type */
#define cSHUNT_TYPE_FAN 				(1)			/* 1 : 1-shunt, 3 : 3-shunt */
#define cBOOT_TYPE_FAN					(cBoot_v)	/* cBoot_i : Current control, cBoot_v: Volt control */

#define cSHUNT_ZERO_OFFSET_FAN			(2.5f)		/* [V] Shunt ad offset voltage (shunt ad voltage of 0A) */

/* AD Channel */
#if !defined(__USE_INAMP_FAN)
#define cADCH_CURRENT_U_FAN 			(18)		/* AD channel for U-phase current of 3shunt */
#define cADCH_CURRENT_V_FAN 			(17)		/* AD channel for V-phase current of 3shunt */
#define cADCH_CURRENT_W_FAN 			(16)		/* AD channel for W-phase current of 3shunt */
#define cADCH_CURRENT_IDC_FAN			(16)		/* AD Channel for DC current of 1shunt */
#else
#define cADCH_CURRENT_U_FAN 			(18)		/* AD channel for U-phase current of 3shunt */
#define cADCH_CURRENT_V_FAN 			(17)		/* AD channel for V-phase current of 3shunt */
#define cADCH_CURRENT_W_FAN 			(16)		/* AD channel for W-phase current of 3shunt */
#define cADCH_CURRENT_IDC_FAN			(16)		/* AD Channel for DC current of 1shunt */
#endif /* __USE_INAMP_FAN */

#define cADCH_VDC_FAN					(9)			/* AD Channel for power supply voltage */
#define c1S 							(1000)				/*[ms] 1s->1ms*/

/* Over current */
#define cOVC_FAN						(1.5f)		/* [A] Over current  */

/* Over voltage */
#define cVDC_MINLIM_FAN 				(100)				/* [V] Vdc min limit */
#define cVDC_MAXLIM_FAN 				(cV_MAX_FAN - 1.0f)	/* [V] Vdc max limit */

/*===================================================================*
	  Motor Parameter Definition
 *===================================================================*/
#if defined(__TYPE_HIGH_VOLT)
#define USE_FAN_MOTOR
#endif

/* PWM Parameter */
#if defined(USE_FAN_MOTOR)
#define cPWMPRD_FAN 					(64.0f)	    		/* [us] PWM Period */
#define cDEADTIME_FAN					(1.0f)	    		/* [us] Dead time */
#define cREPTIME_FAN					(1)		    		/* Repeat time */
#endif

/* External specification */
#if defined(USE_FAN_MOTOR)
#define cSPEED_ACT_FAN					(10.0f)	    		/* [Hz or RPM] Target speed of motor */
#endif

#if defined(USE_FAN_MOTOR)
#define cID_ST_USER_ACT_FAN 			(0.4f)				/* [A] Start current (Id) */
#define cIQ_ST_USER_ACT_FAN 			(0.4f)				/* [A] Start current (Iq) */
#define cID_UP_DN_ACT_FAN				(0.2f)	    /* [A] Start current (Id) */
#endif

/* Motor Parameter */
#if defined(USE_FAN_MOTOR)
#define cMOTOR_R_FAN					(12.862f)			/* [Ohm] Winding resistance */
#define cMOTOR_LQ_FAN					(3.041f)			/* [mH] q-axis inductance */
#define cMOTOR_LD_FAN					(cMOTOR_LQ_FAN)		/* [mH] d-axis inductance */
#define cPOLE_FAN						(8)					/* [Pole] Poles of the motor */
#define cPOLEPAIR_FAN					(cPOLE_FAN/2)           /*pole pair*/
#endif

/* Control Gain constant */
#if defined(USE_FAN_MOTOR)
#define cID_KP_FAN						(22.0f)				/* [V/A]  d-axis current control Proportinal gain */
#define cID_KI_FAN						(1000.0f)			/* [V/As] d-axis current control Integral gain */
#define cIQ_KP_FAN						(cID_KP_FAN)		/* [V/A]  q-axis current control Proportinal gain */
#define cIQ_KI_FAN						(cID_KI_FAN)		/* [V/As] q-axis current control Integral gain */
#endif

#if defined(USE_FAN_MOTOR)
#define cPOSITION_KP_FAN				(1.10046f)			/* [Hz/V]  Position estimation Proportinal gain (Kp) */
#define cPOSITION_KI_FAN				(0.71398f)			/* [Hz/Vs] Position estimation Integral gain (Ki) */
#define cSPEED_KP_FAN 					(0.02f)				/* [A/Hz]  Speed Control Proportinal gain */
#define cSPEED_KI_FAN 					(0.03f*2)			/* [A/Hzs] Speed Control Integral gain */
#endif

#define cSPD_PI_PRD_FAN 				(1)					/* Speed PI period */

#if defined(USE_FAN_MOTOR)
#define cFCD_UD_LIM_UPDN_FAN			(3.0f)			    /* [Hz/s] Limitation of the increase value (Forced Stage) */
#define cFCD_UD_LIM_FAN 				(6.0f)				/* [Hz/s] Limitation of the increase value (Forced Stage) */
#define cSTD_UP_LIM_FAN 				(10.0f)				/* [Hz/s] Limitation of the increase value (Steady Stage) */
#define cSTD_DW_LIM_FAN 				(10.0f)				/* [Hz/s] Limitation of the decrease value (Steady Stage) */
#endif

#define cBOOT_LEN_FAN					(0.1f)				/* [s] Time of Bootstrap Stage */
#define cINIT_LEN_FAN					(2.0f)				/* [s] Time of Positioning Stage */
#define cINIT_LEN_FAN_LONG				(5.0f)				/* [s] Time of Positioning Stage */
#define cINIT_WAIT_LEN_FAN				(0.5f)				/* [s] Time of Positioning wait time */
#define cFORCE_LEN0 					(2.0f)			    /* [s] Timeof Maximum Forcing */
#define cFORCE_TIME_USER0				(cFORCE_LEN0/cMAINLOOP_PRD)
#define cPOSITION_DEG					(75.0f)			    /* Degree for Initial Positioning */
#define cGOUP_DELAY_LEN_FAN 			(0.01f)				/* [s] Time of Change-up delay time */

#if defined(USE_FAN_MOTOR)
#define cHZ_MAX_FAN 					(200.0f)			/* [Hz] Maximum speed of motor */
#define cHZ_MIN_FAN 					(60.0f)				/* [Hz] Minimam speed of motor */	/* When set cHZ_MIN > S_speed_actx, not move Stage from Force */
															/* When set cHZ_MIN > S_speed_actx, not move Stage from Force */
#endif

#define cHZ_SPWM_FAN					(120.0f)			/* [Hz] PWM mode change speed */

#define cMINPLS_FAN 					(4.0f)				/* [us] Minimum Pulse (for 1shunt) */
#define cMAXPLS_FAN 					(cPWMPRD_FAN * 0.9f)/* [us] Maximum Pulse (for 3shunt) */

#define cID_LIM_FAN 					(cOVC_FAN * 0.9f)	/* [A] d-axis limitation current */
#define cIQ_LIM_FAN 					(cOVC_FAN * 0.9f)	/* [A] q-axis limitation current */

#define cINITIAL_POSITION_FAN			(0)					/* [deg] Initial position */
#define cMOS_COMPENSATE 				(0.7)				/* [us]Mosfet compensate value for PWM*/
#define cPWM_MIN_FAN					(FIX_15 * (cDEADTIME_FAN + cMOS_COMPENSATE) / cPWMPRD_FAN)/*[us]Total compensate value for PWM*/

#if (cSHUNT_TYPE_FAN == 3)
#define cTRG_COMPEN_FAN 				(0.0f)	            /* [us] Trigger compensation time for 3shunt(for SoftVector). Setting range:0 <= x < (cPWMPRD_FAN/2) */
#else
#define cTRG_COMPEN_FAN 				(2.0f)	            /* [us] Trigger compensation time for 1shunt(for SoftVector). Setting range:(-cPWMPRD_FAN/2) < x < (cPWMPRD_FAN/2) */
#endif

#define cTRG0_SHIFT2_FAN				(62.0f)	            /* [us] TRG0 time for 1shunt shift2 mode */
#define cTRG1_SHIFT2_FAN				(7.8f)	            /* [us] TRG1 time for 1shunt shift2 mode */

/*for Voltage control parameter */
#if defined(USE_FAN_MOTOR)
#define cVD_POS_FAN 					(3.5f)				/* [V] Voltage of positioning */
#define cSPD_COEF_FAN					(0.2f)	            /* [-] Speed coefficient */
#define cHZ_V2I_FAN 					(30.0f)				/* [Hz] Speed of switching from voltage control to current control */
#endif

/* for Encoder parameter */
#define cENC_PULSE_NUM_FAN				(2048)		        /* [ppr] Number of Encoder pulse */
#define cENC_DEG_ADJUST_FAN 			(180)		        /* [deg] Adjust Z-phase,0deg of electrical-angle */
#define cENC_NOISE_TIME_FAN 			(0.1f)		        /* [us] Encoder signal input noise cancel time. unit:fc/8 (66.7ns@120MHz) Max:8.4us@120MHz (for A-ENC only) */

/* for Fixed Vdc parameter */
#define cVDC_FAN						(24.0f)		        /* [V] Power Voltage */

/*===================================================================*/

/* Control period of motor */
#define cCTRL_PRD_FAN					(cPWMPRD_FAN * cREPTIME_FAN * 1e-6)						/* [s] */
#define cSPD_CTRL_PRD_FAN				(cSPD_PI_PRD_FAN * cPWMPRD_FAN * cREPTIME_FAN * 1e-6)	/* [s] */

/*===================================================================*
	Parameter check
 *===================================================================*/
#if (!((cPOLH_FAN == 0) || (cPOLH_FAN == 1)))
#error cPOLH_FAN define error. cPOLH_FAN only 0 or 1.
#endif

#if (!((cPOLL_FAN == 0) || (cPOLL_FAN == 1)))
#error cPOLL_FAN define error. cPOLL_FAN only 0 or 1.
#endif

#if (!((cSHUNT_TYPE_FAN == 1) || (cSHUNT_TYPE_FAN == 3)))
#error cSHUNT_TYPE_FAN define error. cSHUNT_TYPE_FAN only 1 or 3.
#endif

#if defined(__TYPE_LOW_VOLT) && defined(__TYPE_HIGH_VOLT)
#error __TYPE_LOW_VOLT or __TYPE_HIGH_VOLT define error.
#endif

#endif /* _D_PARA_FAN_H */

/*************************** END OF FILE **************************************/
