/**
 ****************************************************************************
 * @file     initial.c
 * @brief    Initialize Functions for TOSHIBA 'TMPM4K' Device Series
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENCE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2021
 *****************************************************************************
 */

#define DEFINE_APP
#include "initial.h"
#undef  DEFINE_APP
#include "ipdefine.h"

/*===================================================================*
	  Constant Data Definition
 *===================================================================*/
#define	INT4KH_TMR_CH			TSB_T32A0
#define	INT4KH_IRQ_NUMBER		INTT32A00AC_IRQn
#define	INT4KH_LEVEL			5								/* 4kH interval timer interrupt */
#define INT4KH_IRQ_LEVEL		INT4KH_LEVEL

#define	TMR_DIV2_PRD(x)			(uint16_t)( (uint32_t)x * cIMCLK_FRQ / 2)
#define	TMR_DIV8_PRD(x)			(uint16_t)( (uint32_t)x * cIMCLK_FRQ / 8)
#define	TMR_DIV32_PRD(x)		(uint16_t)( (uint32_t)x * cIMCLK_FRQ / 32)
#define	TMR_DIV64_PRD(x)		(uint16_t)( (uint32_t)x * cIMCLK_FRQ / 64)
#define	TMR_DIV128_PRD(x)		(uint16_t)( (uint32_t)x * cIMCLK_FRQ / 128)
#define	TMR_DIV256_PRD(x)		(uint16_t)( (uint32_t)x * cIMCLK_FRQ / 256)
#define	TMR_DIV512_PRD(x)		(uint16_t)( (uint32_t)x * cIMCLK_FRQ / 512)

#define	TMR_PRD_4KH				TMR_DIV8_PRD(250)

/**
 *********************************************************************************************
 * @brief		Initialize 4kH interval Timer.
 *
 * @return		none
 *********************************************************************************************
 */
void init_Timer_interval4kH(void)
{
	T32A_InitTypeDef t32a_00_a = {0};

	/* Enable clock supply to T32A00 */
	CG_SetFsysSupplyPeriphA(CG_FSYS_PERIPH_T32A0, ENABLE);

	t32a_00_a.CounterMode = T32A_CNT_MOD_UP;
	t32a_00_a.ClkSrc = T32A_CLK_SRC_PRESCALER;
	t32a_00_a.ClkDiv = T32A_CLK_DIV_8;
	t32a_00_a.Compare1Value = TMR_PRD_4KH;		/* periodic time is 4kHz set to RGA1 */
	t32a_00_a.ReloadValue = 0x0000U;			/* reload register is 0x0000 */

	/* Set 16 bit mode for timer A */
	T32A_SetMode(INT4KH_TMR_CH, MODE_16);
	T32A_Enable(INT4KH_TMR_CH, TIMER_A);
	/* initialize timer A channel 0 */
	T32A_Init(INT4KH_TMR_CH, TIMER_A, &t32a_00_a);

	/* Set reload condition when counter match with RGA1 */
	T32A_SetReloadCond(INT4KH_TMR_CH, TIMER_A, T32A_COND_MATCH_COMPARE1);
	/* compare0 timing is not used in T32A_INTERVAL_TIMER mode */
	T32A_SetINTMask(INT4KH_TMR_CH, TIMER_A, T32A_INTMASK_MATCH_COMPARE0);
	/* Enable interrupt T32A Timer A channel 0 */
	NVIC_SetPriority(INT4KH_IRQ_NUMBER, INT4KH_IRQ_LEVEL);
	NVIC_ClearPendingIRQ(INT4KH_IRQ_NUMBER);
	NVIC_EnableIRQ(INT4KH_IRQ_NUMBER);

	/* counter start */
	T32A_SetRunStateBySW(INT4KH_TMR_CH, TIMER_A, T32A_START_BY_SW);
}


/**
 *********************************************************************************************
 * @brief		Initialize WDT
 *
 * @return		none
 *********************************************************************************************
 */
void init_WDT(void)
{
	/* Enable clock supply to SIWDT */
	CG_SetFsysSupplyPeriphB(CG_FSYS_PERIPH_SIWDT, ENABLE);
	
	/* Set clock source for SIWDT */
	SIWDT_SetClockSource(SIWDT_CLOCK_SOURCE_FSYS_DIVIDE_FOUR);
	
	/* Set detection time */
	// SIWDT_SetDetectTime(SIWDT_DETECT_TIME_EXP_29);	/* 25sec */
	// SIWDT_SetDetectTime(SIWDT_DETECT_TIME_EXP_27);	/* 7sec */
	SIWDT_SetDetectTime(SIWDT_DETECT_TIME_EXP_25);	/* 2sec */
	
	/* Set clear window for SIWDT */
	SIWDT_SetClearWindow(SIWDT_CLEAR_WINDOW_NOT_SPECIFIED);
	/* SIWDT_SetClearWindow(SIWDT_CLEAR_WINDOW_LATTER_A_HALF); */
	
	/* Set operation after detect malfunction */
	SIWDT_SetOperationAfterDetectMalFunction(SIWDT_OPERATION_RESET);
	
	SIWDT_WriteClearCode();
	SIWDT_Enable();
	
	/* Set protect mode of SIWDT */
	SIWDT_SetProtectMode(SIWDT_NO_PROTECTION);
}

/*********************************** END OF FILE ******************************/
