/**
 ****************************************************************************
 * @file     main.c
 * @brief    main Functions
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENCE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2021
 *****************************************************************************
 */
#include <stdlib.h>

#include "initial.h"
#include "usercon.h"
#include "ipdefine.h"

/*===================================================================*
	Proto Type Definition
 *===================================================================*/
void main_loop(void);

/*===================================================================*
	Function
 *===================================================================*/

/*===================================================================*
	  Local Constant Data Definition
 *===================================================================*/
/*  */
#define	cMAINLOOP_CNT			((uint16_t)(cMAINLOOP_PRD / (250 * 1e-6)))		/* Main roop time */

/* Motor Reset */
#define Motor_RESET				TSB_PN_DATA_PN0 				/* Motor reset pin */
#define RESET_Time				(100)							/* Motor reset low output time */

#define HIGH				(1)
#define LOW 				(0)

/*===================================================================*
	  Local Variable Definition
 *===================================================================*/
static uint8_t		motor_reset_time;							/*  */

/**
 *********************************************************************************************
 * @brief		main Routine
 *
 * @return		int
 *********************************************************************************************
 */
int main(void)
{

	/***** Initial Setting *****/
	__disable_irq();									/* DI */

	init_WDT();											/* Initial setting of WDT */

	init_Timer_interval4kH();							/* Initial setting of interval timer. */

	init_Uikey();										/* Initial setting of user control. */

	__enable_irq(); 									/* EI */

	/***** Motor Reset *****/
	CG_SetFsysSupplyPeriphA(CG_FSYS_PERIPH_PORTN, ENABLE);
	Motor_RESET = LOW;
	TSB_PN->CR  |= (1 << 0U);	/* PN0:OUTPUT */

	while (motor_reset_time <= RESET_Time)
	{
		if (M_Main_Counter >= cMAINLOOP_CNT)
		{
			M_Main_Counter = 0;

			SIWDT_WriteClearCode();
			motor_reset_time++;
		}
	}

	Motor_RESET = HIGH;

	UikeyInitscan();

	/***** Control ModeFCommunication *****/

	/***** Initial Setting *****/
	init_led();										/* Initial setting of LED output */
	init_uart();									/* Initial setting of UART */

	/***** Main Loop *****/
	main_loop();

	return 0;
}

/**
 *********************************************************************************************
 * @brief		main_loop
 *
 * @return		none
 *********************************************************************************************
 */
void main_loop(void)
{
	while (1)
	{
		if (M_Main_Counter >= cMAINLOOP_CNT)
		{
			M_Main_Counter = 0;

			/***** Clear WDT *****/
			SIWDT_WriteClearCode();

			/***** User control *****/
			/***** Timer control *****/
			timer_count();

			/***** key input *****/
			Uikeyscan();

			/***** user setting *****/
			user_setting();

			/***** led output *****/
			led_display();

			/***** UART control *****/
			uart_control();

			/***** Terminal output *****/
			terminal_display();
		}
	}
}

/*********************************** END OF FILE ******************************/
