/**
 ****************************************************************************
 * @file     usercon.h
 * @brief    User Control Definitions
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENCE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2021
 *****************************************************************************
 */
#ifndef _USERCON_H
#define _USERCON_H

#undef EXTERN
#ifdef DEFINE_APP
#define EXTERN
#else
#define EXTERN  extern
#endif

#include "ipdefine.h"

/*****************************************************************
	Define for Software & Hardware setting
******************************************************************/

/*===================================================================*
	Define Typedef
*===================================================================*/
typedef union
{
	struct
	{
		uint8_t	sw8	: 1;
		uint8_t	sw7	: 1;
		uint8_t	sw6	: 1;
		uint8_t	sw5	: 1;
		uint8_t	sw4	: 1;
		uint8_t	sw3	: 1;
		uint8_t	sw2	: 1;
		uint8_t	sw1	: 1;
	} bit;
	uint8_t	all;
} sw_t;


typedef struct
{
	uint8_t	reserve			: 6;			/* reserve */
	uint8_t	keylongpush		: 1;			/* 3000ms KeyLongPush flag */
	uint8_t	timeout			: 1;			/* 100ms Time out flag */
} timer_t;


typedef struct
{
	uint8_t	reserve				: 6;		/* reserve */
	uint8_t	keylongpush_done	: 1;		/* Switch long-press process completion information */
	uint8_t	keydata_set			: 1;		/* Switch input confirmation information */
} key_t;


typedef struct
{
	uint8_t	reserve			: 4;			/* reserve */
	uint8_t	motor_change	: 1;			/* motor change flag */
	uint8_t	motor_pfcchange	: 1;			/* PFC state change flag */
	uint8_t	motor_action	: 1;			/* motor operation request flag */
	uint8_t	motor_stop		: 1;			/* motor stop flag */
} motor_t;


typedef struct
{
	uint8_t	change_disp_status	: 1;		/* Change displaying status flag */
	uint8_t	change_dac			: 1;		/* Change dac mode flag */
	uint8_t	change_ch	: 1;				/* Change displaying channel flag */
	uint8_t	get_status_1		: 1;		/* Information acquisition flag 1(motor state) */
	uint8_t	get_status_2		: 1;		/* Information acquisition flag 2(rotation speed) */
	uint8_t	speed_disp			: 1;		/* rotation speed flag(terminal display) */
	uint8_t	status_disp			: 1;		/* motor state flag(terminal display) */
	uint8_t	disp_stop			: 1;		/* display stop flag */
} disp_t;


typedef struct
{
	uint8_t	reserve			: 3;			/* reserve */
	uint8_t	initialize		: 1;			/* uart initialize */
	uint8_t	data_receive	: 1;			/* receive end */
	uint8_t	emg_bit			: 1;			/* EMG bit */
	uint8_t	na_bit			: 1;			/* N/A bit */
	uint8_t	ack_bit			: 1;			/* ACK bit */
} uart_t;


typedef struct
{
	timer_t		timer;
	key_t		key;
	motor_t		motor;
	disp_t		disp;
	uart_t		uart;
} usercon_flg;

/*===================================================================*
      Proto Type Definition
 *===================================================================*/
EXTERN	void	init_Uikey(void);
EXTERN	void	init_led(void);
EXTERN	void	init_uart(void);

EXTERN	void	UikeyInitscan(void);
EXTERN	void	timer_count(void);
EXTERN	void	Uikeyscan(void);
EXTERN	void	user_setting(void);
EXTERN	void	led_display(void);
EXTERN	void	uart_control(void);
EXTERN	void	terminal_display(void);

EXTERN	void	INT_uart2tx(void);
EXTERN	void	INT_uart2rx(void);

/*===================================================================*
	Variable Definition
 *===================================================================*/

EXTERN	sw_t			keydata;			/* Key data */
EXTERN	usercon_flg		flg;				/* User control flag */

#undef EXTERN
#endif

/******************************** END OF FILE *********************************/
