/**
 *******************************************************************************
 * @file    ipdrv_cg.h
 * @brief   This file provides all the functions prototypes for M4KyA CG driver.
 * @version V1.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __IPDRV_CG_H
#define __IPDRV_CG_H

#ifdef __cplusplus
extern "C" {
#endif                          /* __cplusplus */

/* Includes ------------------------------------------------------------------*/
#include "TMPM4KyA.h"
#include "ipdrv_common.h"

/** @addtogroup TX04_Periph_Driver
  * @{
  */

/** @addtogroup CG
  * @{
  */

/** @addtogroup CG_Exported_types
  * @{
  */

#define CG_FSYS_PERIPH_PORTA      (0x00000001U << 0U)
#define CG_FSYS_PERIPH_PORTB      (0x00000001U << 1U)
#define CG_FSYS_PERIPH_PORTC      (0x00000001U << 2U)
#define CG_FSYS_PERIPH_PORTD      (0x00000001U << 3U)
#define CG_FSYS_PERIPH_PORTE      (0x00000001U << 4U)
#define CG_FSYS_PERIPH_PORTF      (0x00000001U << 5U)
#define CG_FSYS_PERIPH_PORTG      (0x00000001U << 6U)
#define CG_FSYS_PERIPH_PORTH      (0x00000001U << 7U)
#define CG_FSYS_PERIPH_PORTJ      (0x00000001U << 8U)
#define CG_FSYS_PERIPH_PORTK      (0x00000001U << 9U)
#define CG_FSYS_PERIPH_PORTL      (0x00000001U << 10U)
#define CG_FSYS_PERIPH_PORTM      (0x00000001U << 11U)
#define CG_FSYS_PERIPH_PORTN      (0x00000001U << 12U)
#define CG_FSYS_PERIPH_PORTP      (0x00000001U << 13U)
#define CG_FSYS_PERIPH_PORTR      (0x00000001U << 14U)
#define CG_FSYS_PERIPH_PORTT      (0x00000001U << 15U)
#define CG_FSYS_PERIPH_PORTU      (0x00000001U << 16U)
#define CG_FSYS_PERIPH_PORTV      (0x00000001U << 17U)
#define CG_FSYS_PERIPH_PORTW      (0x00000001U << 18U)
#define CG_FSYS_PERIPH_TSPI0      (0x00000001U << 19U)
#define CG_FSYS_PERIPH_TSPI1      (0x00000001U << 20U)
#define CG_FSYS_PERIPH_UART0      (0x00000001U << 21U)
#define CG_FSYS_PERIPH_UART1      (0x00000001U << 22U)
#define CG_FSYS_PERIPH_UART2      (0x00000001U << 23U)
#define CG_FSYS_PERIPH_UART3      (0x00000001U << 24U)
#define CG_FSYS_PERIPH_I2C0       (0x00000001U << 25U)
#define CG_FSYS_PERIPH_I2C1       (0x00000001U << 26U)
#define CG_FSYS_PERIPH_CAN        (0x00000001U << 27U)
#define CG_FSYS_PERIPH_T32A0      (0x00000001U << 28U)
#define CG_FSYS_PERIPH_T32A1      (0x00000001U << 29U)
#define CG_FSYS_PERIPH_T32A2      (0x00000001U << 30U)
#define CG_FSYS_PERIPH_T32A3      (0x00000001U << 31U)
#define CG_FSYS_PERIPHA_ALL       (0xFFFFFFFFU)
#define IS_CG_FSYS_PERIPHA(param) ((param) > 0U)


#define CG_FSYS_PERIPH_T32A4      (0x00000001U << 0U)
#define CG_FSYS_PERIPH_T32A5      (0x00000001U << 1U)
#define CG_FSYS_PERIPH_ADC_A      (0x00000001U << 2U)
#define CG_FSYS_PERIPH_ADC_B      (0x00000001U << 3U)
#define CG_FSYS_PERIPH_ADC_C      (0x00000001U << 4U)
#define CG_FSYS_PERIPH_AMP        (0x00000001U << 5U)
#define CG_FSYS_PERIPH_A_ENC0     (0x00000001U << 6U)
#define CG_FSYS_PERIPH_A_ENC1     (0x00000001U << 7U)
#define CG_FSYS_PERIPH_A_ENC2     (0x00000001U << 8U)
#define CG_FSYS_PERIPH_PMD0       (0x00000001U << 9U)
#define CG_FSYS_PERIPH_PMD1       (0x00000001U << 10U)
#define CG_FSYS_PERIPH_PMD2       (0x00000001U << 11U)
#define CG_FSYS_PERIPH_A_VE_P     (0x00000001U << 12U)
#define CG_FSYS_PERIPH_RAM_PARI1  (0x00000001U << 13U)
#define CG_FSYS_PERIPH_OFD        (0x00000001U << 14U)
#define CG_FSYS_PERIPH_TRIM       (0x00000001U << 15U)
#define CG_FSYS_PERIPH_TRGSEL     (0x00000001U << 16U)
#define CG_FSYS_PERIPH_DMAC       (0x00000001U << 17U)

#define CG_FSYS_PERIPH_BIT29      (0x00000001U << 29U)
#define CG_FSYS_PERIPH_NBD        (0x00000001U << 30U)
#define CG_FSYS_PERIPH_SIWDT      (0x00000001U << 31U)
#define CG_FSYS_PERIPHB_ALL       (0xE003FFFFU)
#define IS_CG_FSYS_PERIPHB(param) (((param) > 0U) && ((param) <= CG_FSYS_PERIPHB_ALL))

#define CG_FSYS_PERIPH_CRC        (0x00000001U << 0U)
#define CG_FSYS_PERIPH_RAM_PARI0  (0x00000001U << 1U)
#define CG_FSYS_PERIPH_ALL        (0x00000003U)
#define IS_CG_FSYS_PERIPH(param)  (((param) > 0U) && ((param) <= CG_FSYS_PERIPH_ALL))

#define CG_FC_PERIPH_OFD        (0x00000001U << 23U)
#define CG_FC_PERIPH_DNF_A      (0x00000001U << 26U)
#define CG_FC_PERIPH_DNF_B      (0x00000001U << 27U)
#define CG_FC_PERIPH_DNF_C      (0x00000001U << 28U)
#define CG_FC_PERIPH_ALL        (0x1C800000U)
#define IS_CG_FC_PERIPH(param)  (((param) >= CG_FC_PERIPH_OFD) && ((param) <= CG_FC_PERIPH_ALL))


/** @} */
/* End of group CG_Exported_types */

/** @defgroup CG_Exported_FunctionPrototypes
  * @{
  */
    void CG_SetFsysSupplyPeriphA(uint32_t Periph, FunctionalState NewState);
    void CG_SetFsysSupplyPeriphB(uint32_t Periph, FunctionalState NewState);
    void CG_SetFcSupplyPeriph(uint32_t Periph, FunctionalState NewState);
	void CG_SetAdcClkSupply(TSB_AD_TypeDef * ADx, FunctionalState NewState);
    void CG_SetTraceClkSupply(FunctionalState NewState);

/** @} */
/* End of group CG_Exported_FunctionPrototype */

/** @} */
/* End of group CG */

/** @} */
/* End of group TX04_Periph_Driver */

#ifdef __cplusplus
}
#endif                          /* __cplusplus */
#endif                          /* __IPDRV_CG_H */
